#ifndef MARS_MHDisp
#define MARS_MHDisp

#ifndef MARS_MH
#include "MH.h"
#endif

#ifndef ROOT_TArrayI
#include <TArrayI.h>
#endif

class TH1F;
class TH2F;
class TProfile;
class MImageParDisp;
class MSrcPosCam;
class MHillas;
class MHillasExt;
class MNewImagePar;
class MMcEvt;
class MPointingPos;
class MHMatrix;

class MHDisp : public MH
{
private:

    MImageParDisp *fImageParDisp;  // container with the estimated Disp
    MSrcPosCam    *fSrcPos;
    MHillas       *fHil;
    MHillasExt    *fHilExt;
    MNewImagePar  *fNewPar;
    MMcEvt        *fMcEvt;
    MPointingPos  *fPointing;

    TString fImageParDispName;

    Int_t fSelectedPos;      // flag to select which Disp estimated position
                             // we want to fill the histograms (see Set function)

    TH1F *fHistEnergy;       // Energy distribution of events
    TH1F *fHistSize;         // Size distribution of events
    TH1F *fHistcosZA;        // cosinus Zenith angle distribution of events
    TH2F *fSkymapXY;         // 2D histogram for Disp estimated source positions
    TH1F *fHistChi2;         // Histogram of the event Chi^2 (= d^2 = distance^2 
                             // between Disp estimated and true source position)
    TH2F *fHistDuDv;         // Distribution of longitudinal (Du) and transversal 
                             // (Dv) distances between Disp and true source position    
    TH2F *fHistChi2Energy;   // Chi^2 (= d^2) vs. Energy
    TH2F *fHistChi2Size;     // Chi^2 (= d^2) vs. Size
    TH2F *fHistDuEnergy;     // Du vs. Energy
    TH2F *fHistDuSize;       // Du vs. Size
    TH2F *fHistDvEnergy;     // Dv vs. Energy
    TH2F *fHistDvSize;       // Dv vs. Size
    TProfile *fEvCorrAssign; // % events with source position well assign vs. Size 


    Double_t fMm2Deg;        // conversion factor from mm to deg

    MHMatrix *fMatrix;       // matrix storing variables needed for Disp optimization
    TArrayI fMap;            // array storing the matrix mapping of columns defined
                             // in MDispCalc::InitMapping

    Double_t GetVal(Int_t i) const;

    Int_t fNumEv;            // total number of events
    Double_t fSumChi2;       // current sum of Chi^2      
    Double_t fChi2;          // final Chi^2 of the Disp optimization

public:

    MHDisp(const char *imagepardispname = "MImageParDisp",
	   const char *name=NULL, const char *title=NULL);
    ~MHDisp();

    Bool_t SetupFill(const MParList *plist);
    Bool_t Fill(const MParContainer *par, const Stat_t w=1);
    Bool_t Finalize();  

    void SetSelectedPos(Int_t iflag);

    void SetMatrixMap(MHMatrix *matrix, TArrayI &map);    

    Double_t GetChi2()     { return fChi2; }

    TH1F *GetHistEnergy()       { return fHistEnergy; } 
    TH1F *GetHistSize()         { return fHistSize; } 
    TH1F *GetHistcosZA()        { return fHistcosZA; } 
    TH2F *GetSkymapXY()         { return fSkymapXY; }
    TH1F *GetHistChi2()         { return fHistChi2; }
    TH2F *GetHistDuDv()         { return fHistDuDv; }
    TH2F *GetHistChi2Energy()   { return fHistChi2Energy; }
    TH2F *GetHistChi2Size()     { return fHistChi2Size; }
    TH2F *GetHistDuEnergy()     { return fHistDuEnergy; }
    TH2F *GetHistDuSize()       { return fHistDuSize; }
    TH2F *GetHistDvEnergy()     { return fHistDvEnergy; }
    TH2F *GetHistDvSize()       { return fHistDvSize; }
    TProfile *GetEvCorrAssign() { return fEvCorrAssign; }

    void Draw(Option_t *opt="");

    ClassDef(MHDisp, 1) // Container holding the Histograms for Disp
};

#endif


