#ifndef MARS_MTriggerCell
#define MARS_MTriggerCell

#ifndef MARS_MCamEvent
#include "MCamEvent.h"
#endif
#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif 

#ifndef ROOT_TArrayL
#include <TArrayL.h>
#endif

class MTriggerCell : public MParContainer, public MCamEvent
{
    friend class MReportTrigger;
private:
    Byte_t  fStatus;         // Monitor of the L2T status

    Int_t gsNCells=19;       //Number of trigger cells

    TArrayL fCellRate;       // Array of the measured L1 cell rates

public:
    MTriggerCell() : fCellRate(gsNCells)
    {
        fName  = "MTriggerCell";
        fTitle = "Container for the measured cell rates";
    }

    Float_t GetMean() const { return fCellRate.GetSum()/fCellRate.GetSize(); }

    Bool_t GetPixelContent(Double_t &val, Int_t idx, const MGeomCam &cam, Int_t type=0) const
    {
      if (idx > gsNCells)
	return kFALSE;
      
      val = fCellRate[idx];
        return val>0;
    }

    Double_t operator[](const UInt_t idx) 
      { 
	if (idx > gsNCells)
	  return kFALSE;
	
	return fCellRate[idx]; 
      }

    void DrawPixelContent(Int_t num) const
    {
    }

    ClassDef(MTriggerCell, 1) // Container for the trigger cell rates
};

#endif
