// temporal solution:
#define MAXNUMEVENTS 500000
#define LOG3000      log(3000.)

TString HILLASFILENAME;
TString DATPARAMIN;
TString DATPARAMOUT;
TString ROOTPLOTNAME;
Int_t imnum = 0;

TVectorD lengthpar(MAXNUMEVENTS);
TVectorD widthpar(MAXNUMEVENTS);
TVectorD distpar(MAXNUMEVENTS);
TVectorD alphapar(MAXNUMEVENTS);
TVectorD sizepar(MAXNUMEVENTS);
TVectorD deltapar(MAXNUMEVENTS);
TVectorD xpar(MAXNUMEVENTS);
TVectorD ypar(MAXNUMEVENTS);
TVectorD conc1(MAXNUMEVENTS);
TVectorD leak1(MAXNUMEVENTS);
TVectorD cosgam(MAXNUMEVENTS);
TVectorD singam(MAXNUMEVENTS);

// the alpha histogram
MBinning bins;

//TH1F histalphagrid;
//histalphagrid.SetName("Alpha");
//histalphagrid.SetTitle("Alpha");
//histalphagrid.SetXTitle("Alpha [deg]");
//histalphagrid.SetYTitle("Counts");
//histalphagrid.SetDirectory(NULL);
//histalphagrid.SetFillStyle(4000);
//histalphagrid.UseCurrentStyle(); 

bins.SetEdges(18, 0.0, 90.);
bins.Apply(histalphagrid);



// possible histograms:
TH1F histlength;
TH1F histwidth;
TH1F histsize;
TH1F histalpha;
TH1F histdist;
TH1F histmeanx;
TH1F histmeany;
TH1F histalphafinal;

TH2F hist2xy("CoG1","Center of Gravity", 100, -1.8, 1.8, 100, -1.8, 1.8);
TH1F histLoverS;
TH1F aftercuthistlength;
TH1F aftercuthistwidth;
TH1F aftercuthistsize;
TH1F aftercuthistalpha;
TH1F aftercuthistdist;
TH1F aftercuthistmeanx;
TH1F aftercuthistmeany;
TH2F aftercuthist2xy("CoG2","Center of Gravity", 100, -1.8, 1.8, 100, -1.8, 1.8);
TH2F hist2lw("Length-Width", "correlation Length-Width", 100, 0.0, 1.0, 100, 0.0, 0.5);
TH2F hist2lalpha("Length-Alpha", "correlation Length-Alpha", 100, 0.0, 1.0, 100, -100., 100.);
TH2F hist2ldist("Length-Dist","correlation Length-Dist", 100, 0.0, 1.0, 100, 0.0, 1.6);
TH2F hist2walpha("Width-Alpha","correlation Width-Alpha", 100, 0.0, 0.5, 100, -100., 100.);
TH2F hist2wdist("Width-Dist","correlation Width-Dist", 100, 0.0, 0.5, 100, 0.0, 1.6);
TH2F hist2alphadist("Alpha-Dist","correlation Alpha-Dist", 100, -100., 100, 100, 0.2, 1.4);


TH2F histskyplot("SPSignif2ndOrder","Sky Plot of significance (2nd order fit)", 
                 NUMSTEPS, MINXGRID - 0.5*STEPGRID, MAXXGRID + 0.5*STEPGRID,
                 NUMSTEPS, MINYGRID - 0.5*STEPGRID, MAXYGRID + 0.5*STEPGRID);
//histskyplot.SetXTitle("-RA [deg]");
//histskyplot.SetYTitle("DEC [deg]");
histskyplot.SetDirectory(NULL);
histskyplot.SetFillStyle(4000);
histskyplot.UseCurrentStyle();

TH2F histNexOnOff("SPNexOnOff","Sky Plot of Number of excess events (using ON and OFF data)", 
                 NUMSTEPS, MINXGRID - 0.5*STEPGRID, MAXXGRID + 0.5*STEPGRID,
                 NUMSTEPS, MINYGRID - 0.5*STEPGRID, MAXYGRID + 0.5*STEPGRID);
//histNexOnOff.SetXTitle("-RA [deg]");
//histNexOnOff.SetYTitle("DEC [deg]");
histNexOnOff.SetDirectory(NULL);
histNexOnOff.SetFillStyle(4000);
histNexOnOff.UseCurrentStyle();

TH2F histChi2Off("SPChi2PerNdf2ndOrderOff","Sky Plot of Chi2/ndf (2nd order fit, OFF data)", 
                 NUMSTEPS, MINXGRID - 0.5*STEPGRID, MAXXGRID + 0.5*STEPGRID,
                 NUMSTEPS, MINYGRID - 0.5*STEPGRID, MAXYGRID + 0.5*STEPGRID);
//histChi2Off.SetXTitle("-RA [deg]");
//histChi2Off.SetYTitle("DEC [deg]");
histChi2Off.SetDirectory(NULL);
histChi2Off.SetFillStyle(4000);
histChi2Off.UseCurrentStyle();

TH2F histskyplotOnOff("SPSignifOnOff","Sky Plot of significance (using ON and OFF data)", 
                 NUMSTEPS, MINXGRID - 0.5*STEPGRID, MAXXGRID + 0.5*STEPGRID,
                 NUMSTEPS, MINYGRID - 0.5*STEPGRID, MAXYGRID + 0.5*STEPGRID);
//histskyplotOnOff.SetXTitle("-RA [deg]");
//histskyplotOnOff.SetYTitle("DEC [deg]");
histskyplotOnOff.SetDirectory(NULL);
histskyplotOnOff.SetFillStyle(4000);
histskyplotOnOff.UseCurrentStyle();

TH2F histNex("SPNex2ndOrder","Sky Plot of Number of excess events (2nd order fit)",
                 NUMSTEPS, MINXGRID - 0.5*STEPGRID, MAXXGRID + 0.5*STEPGRID,
                 NUMSTEPS, MINYGRID - 0.5*STEPGRID, MAXYGRID + 0.5*STEPGRID);
//histNex.SetXTitle("-RA [deg]");
//histNex.SetYTitle("DEC [deg]");
histNex.SetDirectory(NULL);
histNex.SetFillStyle(4000);
histNex.UseCurrentStyle();

TH2F histChi2("SPChi2PerNdf2ndOrderOn","Sky Plot of Chi2/ndf (2nd order fit)", 
                 NUMSTEPS, MINXGRID - 0.5*STEPGRID, MAXXGRID + 0.5*STEPGRID,
                 NUMSTEPS, MINYGRID - 0.5*STEPGRID, MAXYGRID + 0.5*STEPGRID);
//histChi2.SetXTitle("-RA [deg]");
//histChi2.SetYTitle("DEC [deg]");
histChi2.SetDirectory(NULL);
histChi2.SetFillStyle(4000);
histChi2.UseCurrentStyle();

TH2F histskyplot4("SPSignif4thOrder","Sky Plot of significance (4th order fit)", 
                 NUMSTEPS, MINXGRID - 0.5*STEPGRID, MAXXGRID + 0.5*STEPGRID,
                 NUMSTEPS, MINYGRID - 0.5*STEPGRID, MAXYGRID + 0.5*STEPGRID);
//histskyplot4.SetXTitle("-RA [deg]");
//histskyplot4.SetYTitle("DEC [deg]");
histskyplot4.SetDirectory(NULL);
histskyplot4.SetFillStyle(4000);
histskyplot4.UseCurrentStyle();

TH2F histskyLiMa("SPSignifLiMaOnOff","Sky Plot of significance (ON - OFF LiMa17)", 
                 NUMSTEPS, MINXGRID - 0.5*STEPGRID, MAXXGRID + 0.5*STEPGRID,
                 NUMSTEPS, MINYGRID - 0.5*STEPGRID, MAXYGRID + 0.5*STEPGRID);
//histskyLiMa.SetXTitle("-RA [deg]");
//histskyLiMa.SetYTitle("DEC [deg]");
histskyLiMa.SetDirectory(NULL);
histskyLiMa.SetFillStyle(4000);
histskyLiMa.UseCurrentStyle();

TH2F histBerlin("SPBerlinMethod","Sky Plot of Events below alpha 8 degrees", 
                 NUMSTEPS, MINXGRID - 0.5*STEPGRID, MAXXGRID + 0.5*STEPGRID,
                 NUMSTEPS, MINYGRID - 0.5*STEPGRID, MAXYGRID + 0.5*STEPGRID);
//histskyLiMa.SetXTitle("-RA [deg]");
//histskyLiMa.SetYTitle("DEC [deg]");
histBerlin.SetDirectory(NULL);
histBerlin.SetFillStyle(4000);
histBerlin.UseCurrentStyle();

TH1F histsign;
histsign.SetName("Significance 1");
histsign.SetTitle("Significance (2nd order fit)");
histsign.SetXTitle("significance");
histsign.SetYTitle("Counts");
histsign.SetDirectory(NULL);
histsign.SetFillStyle(4000);
histsign.UseCurrentStyle(); 

 bins.SetEdges(20, -5., 8.);
 bins.Apply(histsign);

TH1F histsign4;
histsign4.SetName("Significance 2");
histsign4.SetTitle("Significance (4th order fit)");
histsign4.SetXTitle("significance");
histsign4.SetYTitle("Counts");
histsign4.SetDirectory(NULL);
histsign4.SetFillStyle(4000);
histsign4.UseCurrentStyle(); 

 bins.SetEdges(20, -5., 8.);
 bins.Apply(histsign4);


TH1F histalphagrid;
histalphagrid.SetName("Alpha");
histalphagrid.SetTitle("Alpha");
//histalphagrid.SetXTitle("Alpha [deg]");
histalphagrid.SetYTitle("Counts");
histalphagrid.SetDirectory(NULL);
histalphagrid.SetFillStyle(4000);
histalphagrid.UseCurrentStyle(); 

 bins.SetEdges(18, 0.0, 90.);
 bins.Apply(histalphagrid);

/*
#define n 100
Double_t binsize[n];
Float_t nmin = 100.;
Float_t nmax = 1e7;

for(Int_t i=0; i<n; i++)
{
binsize[i] = pow(10., log10(nmin) + i * (log10(nmax) - log10(nmin)) / (n-1.));
}

TH2F hist2wsize("Width-Size", "correlation Width-Size", 100, 0.0, 0.5, n-1, binsize);
TH2F hist2alphasize("Alpha-Size","correlation Alpha-Size", 100, -100., 100., n-1, binsize);
TH2F hist2distsize("Dist-Size","correlation Dist-Size", 100, 0.0, 1.6, n-1, binsize);
*/
