/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Eva Domingo,     12/2004 <mailto:domingo@ifae.es>
!              Wolfgang Wittek, 12/2004 <mailto:wittek@mppmu.mpg.de>
!
!   Copyright: MAGIC Software Development, 2000-2005
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
//   MDispParameters                                                       //
//                                                                         //
//   this is the container for the Disp parameters                         //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////
#include "MDispParameters.h"

#include <math.h>
#include <fstream>

#include <TArrayD.h>

#include "MImageParDisp.h"

#include "MParList.h"

#include "MLog.h"
#include "MLogManip.h"


ClassImp(MDispParameters);

using namespace std;

// --------------------------------------------------------------------------
//
// constructor
//
MDispParameters::MDispParameters(const char *name, const char *title)
{
    fName  = name  ? name  : "MDispParameters";
    fTitle = title ? title : "Container for the Disp parameters";
}


// --------------------------------------------------------------------------
//
// set default values for the Disp parameters
//
void MDispParameters::InitParameters()
{
    //---------------------------------------------------
    //  these are the default values

    fParameters[0] =  1.0;
    fParameters[1] =  0.6;
    fParameters[2] = -0.8;
    fParameters[3] = -0.8;
    fParameters[4] = -1.2;


    //---------------------------------------------------
    // fStepsizes 
    // if == 0.0    the parameter will be fixed in the minimization
    //    != 0.0    initial step sizes for the parameters

    fStepsizes[0] = 0.010;
    fStepsizes[1] = 0.006;
    fStepsizes[2] = 0.008;
    fStepsizes[3] = 0.008;
    fStepsizes[4] = 0.012;
}


// --------------------------------------------------------------------------
//
// Set the parameter values from the array 'd'
//
//
Bool_t MDispParameters::SetParameters(const TArrayD &d)
{
    if (d.GetSize() != fParameters.GetSize())
    {
        *fLog << err << "Sizes of d and of fParameters are different : "
              << d.GetSize() << ",  " << fParameters.GetSize() << endl;
        return kFALSE;
    }

    fParameters = d;

    return kTRUE;
}


// --------------------------------------------------------------------------
//
// Set the step sizes from the array 'd'
//
//
Bool_t MDispParameters::SetStepsizes(const TArrayD &d)
{
    if (d.GetSize() != fStepsizes.GetSize())
    {
        *fLog << err << "Sizes of d and of fStepsizes are different : "
              << d.GetSize() << ",  " << fStepsizes.GetSize() << endl;
        return kFALSE;
    }

    fStepsizes = d;

    return kTRUE;
}
