/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Eva Domingo    , 12/2004 <mailto:domingo@ifae.es>
!              Wolfgang Wittek, 12/2004 <mailto:wittek@mppmu.mpg.de>
!
!   Copyright: MAGIC Software Development, 2000-2005
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//
// MImageParDisp
//
// Storage Container for estimated distance to source position (Disp)
//
/////////////////////////////////////////////////////////////////////////////
#include "MImageParDisp.h"

#include "MLog.h"
#include "MLogManip.h"


ClassImp(MImageParDisp);

using namespace std;

// --------------------------------------------------------------------------
//
// Default constructor.
//
MImageParDisp::MImageParDisp(const char *name, const char *title)
{
    fName  = name  ? name  : "MImageParDisp";
    fTitle = title ? title : "Estimated distance to source position (Disp)";

    Reset();
}

// --------------------------------------------------------------------------
//
void MImageParDisp::Reset()
{
    fDisp = -1;
}

// --------------------------------------------------------------------------
//
void MImageParDisp::Print(Option_t *) const
{
    *fLog << all;
    *fLog << "Estimated distance to source position (" << GetName() << ")" << endl;
    *fLog << " - Disp [deg] = " << fDisp << endl;
}
