#ifndef MARS_MTriggerLiveTime
#define MARS_MTriggerLiveTime

#ifndef MARS_MCamEvent
#include "MCamEvent.h"
#endif
#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif 

#ifndef ROOT_TArrayL
#include <TArrayL.h>
#endif

class MTriggerLiveTime : public MParContainer, public MCamEvent
{
    friend class MReportTrigger;

private:
    Byte_t  fStatus;        // Monitor of the L2T status
    
    Int_t gsNScalers=5;        // number of scalers

    TArrayL fLiveTime; // Array with the livetime
    TArrayL fDeadTime; // Array with the deadtime

public:
    MTriggerLiveTime() : fLiveTime(gsNScalers)  
    {
        fName  = "MTriggerLiveTime";
        fTitle = "Container for the Live-deadtime      ";
    }

    Bool_t GetPixelContent(Double_t &val, Int_t idx, const MGeomCam &cam, Int_t type=0) const
    {
      if (idx > gsNScalers)
	return kFALSE;

      val = fLiveTime[idx];	

      return val>0;
    }

    Double_t operator[](const UInt_t idx) 
      {  
	Double_t val=0;

	return GetPixelContent(&val, idx)>0? val: -1; 
      }

    void DrawPixelContent(Int_t num) const
    {
    }

    ClassDef(MTriggerLiveTime, 1) // Container for the Live-Deadtime
};

#endif
