#ifndef MARS_MMySuperCutsCalc
#define MARS_MMySuperCutsCalc

#ifndef MARS_MTask
#include "MTask.h"
#endif

#ifndef ROOT_TArrayD
#include <TArrayD.h>
#endif

class MParList;
class MHillas;
class MHillasSrc;
class MHillasExt;
class MNewImagePar;
class MMcEvt;
class MCerPhotEvt;
class MGeomCam;
class MHadronness;
class MHMatrix;
class MMySuperCuts;
class MPointingPos;
class MNewImagePar;
class MHillasExt;

class MMySuperCutsCalc : public MTask
{
 private:

    MHillas       *fHil;
    MHillasSrc    *fHilSrc;
    MHillasExt    *fHilExt;
    MNewImagePar  *fNewPar;
    MMcEvt        *fMcEvt;
    MHadronness   *fHadronness; //! output container for hadronness
    MMySuperCuts  *fSuper;      // container for supercut parameters
    MPointingPos  *fPointingPos; 
    MNewImagePar  *fNewImagePar;
    MHillasExt    *fHillasExt;

    TString  fHadronnessName;   // name of container to store hadronness
    TString  fHilName;
    TString  fHilSrcName;
    TString  fHilExtName;
    TString  fNewParName;
    TString  fSuperName;        // name of container for supercut parameters

    Double_t fMm2Deg;           //!

    Int_t     fMap[11];         //!
    MHMatrix *fMatrix;          //!

    Bool_t fNoDistCut;
    Float_t fSizeCutLow,fSizeCutUp ;


    Int_t PreProcess(MParList *pList);
    Int_t Process();

    Double_t GetVal(Int_t i) const;

    Double_t CtsMCut(const Double_t* a, Double_t ls, Double_t ls2, Double_t ct, Double_t dd2) const;


 public:
    
    MMySuperCutsCalc(const char *hilname="MHillas",
                      const char *hilsrcname="MHillasSrc",
                      const char *name=NULL, const char *title=NULL);

    void SetHadronnessName(const TString name) { fHadronnessName = name; }
    TString GetHadronnessName() const { return fHadronnessName; }

    void InitMapping(MHMatrix *mat);
    void StopMapping() { InitMapping(NULL); }

   
    /*  Double_t Calc(MMySuperCuts* super, MHillas* hillas, MHillasSrc* hillasSrc, MHadronness* hadronness); */

    Bool_t CalcDistCut(MHillasSrc* hillasSrc);

 
    void SetNoDistCut(Bool_t flag) { fNoDistCut = flag; }
    void SetSizeCuts(Float_t sizeLow, Float_t sizeUp) 
    {
	fSizeCutLow = sizeLow;
	fSizeCutUp = sizeUp;
    }


    ClassDef(MMySuperCutsCalc, 0) // A class to evaluate the Supercuts
};

#endif



















