// pedrmsonoff.C
// compare pedestal rms for two different sets
//

#include "MParList.h"
#include "MTaskList.h"
#include "MPedestalCam.h"
#include "MReadMarsFile.h"
#include "MGeomApply.h"
#include "MPedCalcPedRun.h"
#include "MEvtLoop.h"
#include "MPedestalPix.h"
#include "MHCamera.h"

#include "TTimer.h"
#include "TString.h"
#include "TCanvas.h"
#include "TFile.h"
#include "TGraphErrors.h"
#include "TMultiGraph.h"
#include "TLegend.h"
#include "TPaveStats.h"
#include "TH1F.h"
#include "TStyle.h"
#include "TROOT.h"

#include <iostream>

using namespace std;	     

void compare(TCanvas* canvas,TString onfname, TString offfname,TString descon, TString descoff, UInt_t index=-1);

void pedrmsonoff()
//int main()
{
  // general settings
  gROOT->Reset();
  gStyle->SetCanvasColor(0);
  gStyle->SetStatColor(0);
  gStyle->SetStatBorderSize(1);
  gStyle->SetOptStat(111111);
  gStyle->SetStatW(0.2);
  gStyle->SetStatH(0.1);
  gStyle->SetStatX(0.9);
  gStyle->SetStatY(0.9);

  // create canvas
  TCanvas* canvas = new TCanvas("canvas","On/Off crab pedestal rms", 0, 100, 800, 500);
  canvas->SetBorderMode(0);    // Delete the Canvas' border line     
  canvas->cd();

#ifdef TEMPLATE
  // define input files/parameters
  const UInt_t ncomp = 9;

  //  const TString onfile ="/mnt/disc02/Data/rootdata/CrabNebula/2004_01_26/20040125_10412_P_Crab-On_E.root";
  TString onfile[ncomp] = {
    "/local_disk/jrico/rootdata/20040126_12149_P_Cab-On_E.root",
    "/local_disk/jrico/rootdata/20040125_10412_P_Crab-On_E.root", 
    "/local_disk/jrico/rootdata/20040125_10412_P_Crab-On_E.root",
    "/local_disk/jrico/rootdata/20040119_04642_P_Crab-On_E.root",
    "/local_disk/jrico/rootdata/20040128_1342*_P_ClosedLidsHVoff_E.root",
    "/local_disk/jrico/rootdata/20040128_1342*_P_ClosedLidsLVoff_E.root",
    "/local_disk/jrico/rootdata/20040128_1343*_P_ReciversOff_E.root",
    "/local_disk/jrico/rootdata/20040126_12386_P_Cab-On_E.root",
    "/local_disk/jrico/rootdata/20040126_12543_P_OffCrab-1_E.root"};

  
  TString ondesc[ncomp] = {"Run 12149 Jan 27th, Crab On, #theta 28 deg",
			   "Run 10412 Jan 26th, Crab On, #theta 12.5 deg",
			   "Run 10412 Jan 26th, Crab On, #theta 12.5 deg",			      
			   "Run 4642 Jan 20th, Crab On, #theta 14.1 deg",
			   "Runs 13426-7 Jan 29th, Closed lids HV off",
			   "Runs 13428-9 Jan 29th, Closed lids LV off",
			   "Runs 13430-1 Jan 29th, Recivers Off",
			   "Run 12386 Jan 27th, Crab On #theta 37.1 deg",
			   "Run 12543 Jan 27th, Crab Off #theta 8.6 deg"};

  
  TString offfile[ncomp] = {
    "/local_disk/jrico/rootdata/20040121_06773_P_OffCrab1_E.root",
    "/local_disk/jrico/rootdata/20040125_11477_P_OffCrab1_E.root",
    "/local_disk/jrico/rootdata/20040125_10415_P_Crab-On_E.root",
    "/local_disk/jrico/rootdata/20040125_10415_P_Crab-On_E.root",
    "/local_disk/jrico/rootdata/20040128_13425_P_ClosedLidsHVon_E.root",
    "/local_disk/jrico/rootdata/20040128_13425_P_ClosedLidsHVon_E.root",
    "/local_disk/jrico/rootdata/20040128_13425_P_ClosedLidsHVon_E.root",
    "/local_disk/jrico/rootdata/20040128_13425_P_ClosedLidsHVon_E.root",
    "/local_disk/jrico/rootdata/20040128_13425_P_ClosedLidsHVon_E.root"};

  
  TString offdesc[ncomp] = {"Run 6773 Jan 22nd, Crab Off #theta 28 deg",
			    "Run 11477 Jan 26th, Crab Off #theta 9.2 deg",
			    "Run 10415 Jan 26th, Crab On, #theta 13.8 deg",
			    "Run 10415 Jan 26th, Crab On, #theta 13.8 deg",
			    "Run 13425 Jan 29th, Closed lids HV on",
			    "Run 13425 Jan 29th, Closed lids HV on",
			    "Run 13425 Jan 29th, Closed lids HV on",
			    "Run 13425 Jan 29th, Closed lids HV on",
			    "Run 13425 Jan 29th, Closed lids HV on"};
#endif

  // define input files/parameters
  const UInt_t ncomp = 1;

  TString onfile[ncomp] = {"/local_disk/jrico/rootdata/pedestals/20040619_*_P_OffPSR1957-1_E.root"};  
  TString ondesc[ncomp] = {"Off-PSR1957"};  
  TString offfile[ncomp] = {"/local_disk/jrico/mc/empty_disc00.root"};  
  TString offdesc[ncomp] = {"MC (Vela)"};

  canvas->Print("pedrmsonoff.ps[");  
  for(UInt_t i=0;i<ncomp;i++)    
    compare(canvas,onfile[i],offfile[i],ondesc[i],offdesc[i],i);
  canvas->Print("pedrmsonoff.ps]");  
}


void compare(TCanvas* canvas,TString onfname, TString offfname,TString descon, TString descoff,UInt_t index)
{
  /*************************/
  /* FIRST LOOP: ON DATA   */
  /*************************/

  // basic lists
  MParList plist;
  MTaskList tlist;
  plist.AddToList(&tlist);
  
  // containers
  MPedestalCam   onpedcam;
  plist.AddToList(&onpedcam);
    
  //tasks
  MReadMarsFile read("Events", onfname);
  MGeomApply     geomapl;
  MPedCalcPedRun pedcalc;

  read.DisableAutoScheme();

  tlist.AddToList(&read);
  tlist.AddToList(&geomapl);
  tlist.AddToList(&pedcalc);

  // Create and execute the event looper
  MEvtLoop evtloop;
  evtloop.SetParList(&plist);
  
  cout << "*********************" << endl;
  cout << "** RUNNING ON DATA **" << endl;
  cout << "*********************" << endl;

  if (!evtloop.Eventloop())
    return;
  
  tlist.PrintStatistics();

  /**************************/
  /* SECOND LOOP: OFF DATA  */
  /**************************/
  MReadMarsFile read2("Events",offfname);
  read2.DisableAutoScheme();
  tlist.AddToListBefore(&read2, &read, "All");
  tlist.RemoveFromList(&read);
  
  // containers
  MPedestalCam   offpedcam;
  plist.Remove(&onpedcam);
  plist.AddToList(&offpedcam);
  
  // Execute the event looper
  cout << "**********************" << endl;
  cout << "** RUNNING OFF DATA **" << endl;
  cout << "**********************" << endl;

  if (!evtloop.Eventloop())
    return;
  
  tlist.PrintStatistics();

  /*******************/
  /* FILL HISTOGRAMS */
  /*******************/
  const UInt_t npix = 577;
  const UInt_t ninner = 397;
  const UInt_t imin =  0;
  const UInt_t imax = 20;
  const UInt_t itot = 50;
  
  TH1F* honinpedrms  = new TH1F(descon+TString(" Inner"),"Pedestal RMS" ,itot,imin,imax);
  TH1F* hoffinpedrms = new TH1F(descoff+TString(" Inner"),"Pedestal RMS",itot,imin,imax);
  TH1F* honoutpedrms  = new TH1F(descon+TString(" Outer"),"Pedestal RMS" ,itot,imin,imax);
  TH1F* hoffoutpedrms = new TH1F(descoff+TString(" Outer"),"Pedestal RMS",itot,imin,imax);

  for(UInt_t i=0;i<npix;i++)
    {
      const Float_t onpedrms  =  onpedcam[i].GetPedestalRms();
      const Float_t offpedrms = offpedcam[i].GetPedestalRms();
      
      if(i<ninner)
	{
	  honinpedrms->Fill(onpedrms);
	  hoffinpedrms->Fill(offpedrms);
	}
      else
	{
	  honoutpedrms->Fill(onpedrms);
	  hoffoutpedrms->Fill(offpedrms);
	}
    }

  /*******************/
  /* DRAW HISTOGRAMS */
  /*******************/
     
  // draw pedestal histos
  honinpedrms->GetXaxis()->SetTitle("Pedestal RMS (ADC cnts)");
  honinpedrms->GetYaxis()->SetTitle("# pixels");
  honinpedrms->SetFillStyle(3004);
  honinpedrms->SetFillColor(1);

  hoffinpedrms->GetXaxis()->SetTitle("Pedestal RMS (ADC cnts)");
  hoffinpedrms->GetYaxis()->SetTitle("# pixels");
  hoffinpedrms->SetFillStyle(3005);
  hoffinpedrms->SetFillColor(2);
  hoffinpedrms->SetLineColor(2);

  honoutpedrms->GetXaxis()->SetTitle("Pedestal RMS (ADC cnts)");
  honoutpedrms->GetYaxis()->SetTitle("# pixels");
  honoutpedrms->SetFillStyle(3017);
  honoutpedrms->SetFillColor(1);

  hoffoutpedrms->GetXaxis()->SetTitle("Pedestal RMS (ADC cnts)");
  hoffoutpedrms->GetYaxis()->SetTitle("# pixels");
  hoffoutpedrms->SetFillStyle(3018);
  hoffoutpedrms->SetFillColor(2);
  hoffoutpedrms->SetLineColor(2);

  hoffinpedrms->Draw();
  hoffoutpedrms->Draw("sames");
  honinpedrms->Draw("sames");
  honoutpedrms->Draw("sames");

  // move stat boxes to make them all visible
  gPad->Update();
  TPaveStats* onoutpavstat  = (TPaveStats*) honoutpedrms->GetListOfFunctions()->FindObject("stats");
  TPaveStats* offinpavstat  = (TPaveStats*) hoffinpedrms->GetListOfFunctions()->FindObject("stats");
  TPaveStats* offoutpavstat = (TPaveStats*) hoffoutpedrms->GetListOfFunctions()->FindObject("stats");
  Float_t shifty = offinpavstat->GetY2NDC()-offinpavstat->GetY1NDC();
  Float_t shiftx = onoutpavstat->GetX2NDC()-onoutpavstat->GetX1NDC();

  onoutpavstat->SetX1NDC(onoutpavstat->GetX1NDC()-shiftx);
  onoutpavstat->SetX2NDC(onoutpavstat->GetX2NDC()-shiftx);

  offinpavstat->SetY1NDC(offinpavstat->GetY1NDC()-shifty);
  offinpavstat->SetY2NDC(offinpavstat->GetY2NDC()-shifty);

  offoutpavstat->SetX1NDC(offoutpavstat->GetX1NDC()-shiftx);
  offoutpavstat->SetX2NDC(offoutpavstat->GetX2NDC()-shiftx);
  offoutpavstat->SetY1NDC(offoutpavstat->GetY1NDC()-shifty);
  offoutpavstat->SetY2NDC(offoutpavstat->GetY2NDC()-shifty);

  // include legend
  TLegend* leg1 = new TLegend(.52,.25,.88,.45);
  leg1->SetHeader("");
  leg1->AddEntry(honinpedrms,descon+TString(" (Inner)"),"f");
  leg1->AddEntry(hoffinpedrms,descoff+TString(" (Inner)"),"f");
  leg1->AddEntry(honoutpedrms,descon+TString(" (Outer)"),"f");
  leg1->AddEntry(hoffoutpedrms,descoff+TString(" (Outer)"),"f");
  leg1->SetFillColor(0);
  leg1->SetLineColor(0);
  leg1->SetBorderSize(0);
  leg1->Draw();

  if(index>=0)
    {
      char fname[100];
      sprintf(fname,"pedrmsonoff%02d.eps",index);
      canvas->Print(fname);        
    }
  canvas->Print("pedrmsonoff.ps");  

  return; 
  
}
