#ifndef MARS_MHExcessEnergyThetaONOFF
#define MARS_MHExcessEnergyThetaONOFF

#ifndef MARS_MH
#include "MH.h"
#endif

#ifndef ROOT_TH3
#include <TH2.h>
#endif

#ifndef MARS_MHExcessEnergyTheta
#include "MHExcessEnergyTheta.h"
#endif

class MParList;
class MHAlphaEnergyTheta;
    
class MHExcessEnergyThetaONOFF : public MHExcessEnergyTheta
{
 private:
 
    TH2D fHist;
   
    Bool_t SetupFill(const MParList *pList);
    Bool_t ReInit(MParList *pList);


 public:
 
    MHExcessEnergyThetaONOFF(const char *name=NULL, const char *title=NULL);
    
    void Calc(MHAlphaEnergyTheta* hAlphaON, MHAlphaEnergyTheta* hAlphaOFF);

    Bool_t Fill(const MParContainer *par, const Stat_t w=1);
    
    TH2D *GetHist()      { return &fHist;  }
  
    void Draw(Option_t *option="");
    
    ClassDef(MHExcessEnergyThetaONOFF, 1) //2D-histogram in number of excess events vs. Energy and theta
};

#endif
