#ifndef MARS_MChisqEval
#define MARS_MChisqEval

#ifndef ROOT_MTask
#include "MTask.h"
#endif

class MData;
class MParameterD;

class MChisqEval : public MTask
{
private:
    static const TString gsDefName;
    static const TString gsDefTitle;

    Double_t     fChisq;  //! Evaluated chi square
    MParameterD *fResult; //! Storage for result

    MData   *fData0; // Data Member one (monte carlo data or chisq function)
    MData   *fData1; // Data Member two (measured data)

    // --------------------------------------------------------------------------
    //
    // Implementation of SavePrimitive. Used to write the call to a constructor
    // to a macro. In the original root implementation it is used to write
    // gui elements to a macro-file.
    //
    void StreamPrimitive(ofstream &out) const;

    enum { kIsOwner = BIT(14) };

    Int_t PreProcess(MParList *plist);
    Int_t Process();
    Int_t PostProcess();

public:
    MChisqEval(const char *name=NULL, const char *title=NULL);
    MChisqEval(MData *y1, const char *name=NULL, const char *title=NULL);
    MChisqEval(MData *y1, MData *y2, const char *name=NULL, const char *title=NULL);
    ~MChisqEval();

    void SetY1(MData *data);
    void SetY2(MData *data);
    void SetY1(const TString data);
    void SetY2(const TString data);

    void SetOwner(Bool_t o=kTRUE) { o ? SetBit(kIsOwner) : ResetBit(kIsOwner); }

    Double_t GetChisq() const { return fChisq; }
 
    ClassDef(MChisqEval, 0)
};

#endif
