/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz  07/2001 (tbretz@uni-sw.gwdg.de)
!
!   Copyright: MAGIC Software Development, 2000-2001
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
//   MFTriggerLvl1                                                         //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#include "MFTriggerLvl1.h"

#include "MParList.h"
#include "MLog.h"
#include "MLogManip.h"

#include "MMcTrig.hxx"

ClassImp(MFTriggerLvl1);


// --------------------------------------------------------------------------
//
MFTriggerLvl1::MFTriggerLvl1(const char *cname, const char type, const Int_t val) : fMcTrig(NULL)
{
    fContName = cname;
}

// --------------------------------------------------------------------------
//
MFTriggerLvl1::MFTriggerLvl1(const MMcTrig *mctrig, const char type, const Int_t val) : fMcTrig(mctrig)
{
}

// --------------------------------------------------------------------------
//
void MFTriggerLvl1::Init(const char type, const Int_t val)
{
    fFilterType = (type=='<' ? kELowerThan : kEGreaterThan);

    if (type!='<' && type!='>')
        *fLog << dbginf << "Warning: Neither '<' nor '>' specified... using '>'." << endl;

    fValue = val;
}

// --------------------------------------------------------------------------
//
Bool_t MFTriggerLvl1::IsExpressionTrue() const
{
    return fResult;
}

// --------------------------------------------------------------------------
//
Bool_t MFTriggerLvl1::PreProcess(MParList *pList)
{
    if (fMcTrig)
        return kTRUE;

    fMcTrig = (MMcTrig*)pList->FindObject(fContName);
    if (fMcTrig)
        return kTRUE;

    *fLog << dbginf << fContName << " [MMcTrig] not found... aborting." << endl;
        return kFALSE;
}

// --------------------------------------------------------------------------
//
Bool_t MFTriggerLvl1::Process()
{
    const Int_t lvl1 = fMcTrig->GetFirstLevel();

    switch (fFilterType)
    {
    case kELowerThan:
        fResult = (lvl1 < fValue);
        break;
    case kEGreaterThan:
        fResult = (lvl1 > fValue);
        break;
    }

    return kTRUE;
}

