#include <TROOT.h>
#include <TApplication.h>

#include "MMars.h"
#include "MArray.h"
#include "MParContainer.h"

// **********************************************************************
//
//    MARS main program  
//
//    The only job of the main program is the initialisation of ROOT and 
//    the start of the guiinterface for the mars program
//
//    started by  h. kornmayer      january, 3rd  2001 

int main(int argc, char **argv )
{
    MArray::Class()->IgnoreTObjectStreamer();
    MParContainer::Class()->IgnoreTObjectStreamer();

    //
    // initialise ROOT
    //
    TROOT simple("mars", "MARS - Magic Analysis and Reconstruction Software");

    TApplication app("MarsApp", &argc, argv);

    //
    // start the main window
    //
    new MMars;

    //
    // run the application
    //
    app.Run();

    return 0;
}
 

