/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Harald Kornmayer 1/2001 (harald@mppmu.mpg.de)
!   Author(s): Thomas Bretz  12/2000 (tbretz@uni-sw.gwdg.de)
!
!   Copyright: MAGIC Software Development, 2000-2001
!
!
\* ======================================================================== */

///////////////////////////////////////////////////////////////////////
//
// MHFadcPix
//
// This container stores a hostogram to display an Fadc Spekrtum.
// The spektrum of all the values measured by the Fadcs.
//
///////////////////////////////////////////////////////////////////////

#include "MHFadcPix.h"

#include <TH1.h>
#include <TPad.h>

#include "MH.h"

ClassImp(MHFadcPix);

// --------------------------------------------------------------------------
//
// Creates the histograms for lo and hi gain of one pixel
//
MHFadcPix::MHFadcPix(UInt_t pixid) : fPixId(pixid)
{
    Char_t *name  = StrDup(pixid ? Form("HiGain%03d", pixid) : "HiGain");
    Char_t *title = StrDup(pixid ? Form("Hi Gain Pixel #%d", pixid) : "Hi Gain Samples");

    fHistHi =  new TH1F(name, title, 256, 0, 255);

    fHistHi->SetDirectory(NULL);
    fHistHi->SetXTitle("Signal/FADC Units");
    fHistHi->SetYTitle("Count");

    delete [] name;
    delete [] title;

    name  = StrDup(pixid ? Form("LoGain%03d", pixid) : "LoGain");
    title = StrDup(pixid ? Form("Lo Gain Pixel #%d", pixid) : "Lo Gain Samples");

    fHistLo = new TH1F(name, title, 256, 0, 255);

    fHistLo->SetDirectory(NULL);
    fHistLo->SetXTitle("Signal/FADC Units");
    fHistLo->SetYTitle("Count");

    delete [] name;
    delete [] title;
}

// --------------------------------------------------------------------------
MHFadcPix::~MHFadcPix()
{
    delete fHistHi;
    delete fHistLo;
}

// --------------------------------------------------------------------------
void MHFadcPix::FillHi(Byte_t i)
{
    fHistHi->Fill(i);
}

// --------------------------------------------------------------------------
void MHFadcPix::FillLo(Byte_t i)
{
    fHistLo->Fill(i);
}

// --------------------------------------------------------------------------
void MHFadcPix::DrawHi()
{
    fHistHi->Draw();
}

// --------------------------------------------------------------------------
void MHFadcPix::DrawLo()
{
    fHistLo->Draw();
}

// --------------------------------------------------------------------------
void MHFadcPix::Draw(Option_t *)
{
    if (!gPad)
    {
        const char *name  = StrDup(fPixId ? Form("Pixel #%d", fPixId) : "Pixel");
        const char *title = StrDup(fPixId ? Form("%s FADC Samples", name) : "FADC Samples");
        MH::MakeDefCanvas(name, title);
        delete [] name;
        delete [] title;
    }

    gPad->Divide(1, 2);

    gPad->cd(1);
    fHistHi->Draw();

    gPad->cd(2);
    fHistLo->Draw();
}
