#ifndef MARS_MTaskList
#define MARS_MTaskList

///////////////////////////////////////////////////////////////////////
//                                                                   //
// MTaskList                                                         //
//                                                                   //
// Collection of tasks to be processed in the eventloop              //
//                                                                   //
///////////////////////////////////////////////////////////////////////

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MLog;
class MParList;
class MInputStreamID;

class MTaskList : public MTask
{
private:
    TOrdCollection *fTasks;	// Container for the ordered list of different tasks
    MParList       *fParList;

    UInt_t *fCntContinue;
    UInt_t *fCntTrue;

    enum { kIsOwner = BIT(14) };

public:
    MTaskList(const char *name=NULL, const char *title=NULL);
    MTaskList(MTaskList &ts);

    ~MTaskList();

    void SetLogStream(MLog *log);

    Bool_t AddToList(MTask *task, const char *tType="All", MTask *where = NULL);

    TObject *FindObject(const char *name) const;
    TObject *FindObject(const TObject *obj) const;

    Bool_t PreProcess(MParList *pList);
    Bool_t Process();
    Bool_t PostProcess();

    void Print(Option_t *opt = "") const;
    void PrintStatistics(const Int_t lvl=0) const;
    void SetOwner(Bool_t enable=kTRUE);

    const TOrdCollection *GetList() const { return fTasks; }

    ClassDef(MTaskList, 0)	//collection of tasks to be performed in the eventloop
};

#endif
