#ifndef MARS_MMcPedestalNSB
#define MARS_MMcPedestalNSB

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MMcPedestalNSB                                                          //
//                                                                         //
// This task adds the contribution to pedestal rms from the NSB in the     //
// MARS Container (MPedestals).                                            //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MMcFadcHeader;
class MPedestalCam;

class MMcPedestalNSB : public MTask
{
    TString *fSrc;
    Float_t fdnsb_pixel;

public:
    MMcPedestalNSB(const float difnsb = -1.0,
		   const char *name=NULL, const char *title=NULL);

    Bool_t PreProcess(MParList *pList);

    ClassDef(MMcPedestalNSB, 0)   // Task which adds the NSB fluctuations to the pedestals rms
};

#endif
