#ifndef MARS_MCerPhotCalc
#define MARS_MCerPhotCalc

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MCerPhotCalc                                                            //
//                                                                         //
// Integrates the time slices of one pixel and substracts the pedestal     //
// (offset) value                                                          //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MRawEvtData;
class MPedestalCam;
class MCerPhotEvt;

class MCerPhotCalc : public MTask
{
    const MPedestalCam *fPedestals;  // Pedestals of all pixels in the camera
          MRawEvtData  *fRawEvt;     // raw event data (time slices)
          MCerPhotEvt  *fCerPhotEvt; // Cerenkov Photon Event used for calculation
	  UShort_t fNumLoGainFadcSlices;      //
	  UShort_t fNumHiGainFadcSlices;      //

public:
    MCerPhotCalc(const char *name=NULL, const char *title=NULL);

    Bool_t PreProcess(MParList *pList);
    Bool_t Process();

    ClassDef(MCerPhotCalc, 0)   // Task to calculate cerenkov photons from raw data
};

#endif
