#ifndef MARS_MHMcCollectionArea
#define MARS_MHMcCollectionArea

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

class TH1D;
class TH2D;

class MHMcCollectionArea : public MParContainer
{
private:
    TH2D *fHistAll; //! all simulated showers
    TH2D *fHistSel; //! the selected showers

    TH1D *fHistCol; //  the collection area

public:

    MHMcCollectionArea(const char *name=NULL, const char *title=NULL);
    ~MHMcCollectionArea();

    void FillAll(Float_t energy, Float_t radius);
    void FillSel(Float_t energy, Float_t radius);

    void DrawAll(Option_t *option="");
    void DrawSel(Option_t *option="");

    void Draw(Option_t *option="");
    TObject *DrawClone(Option_t *option="") const;

    void CalcEfficiency();

    ClassDef(MHMcCollectionArea, 1)  // Data Container to calculate Collection Area
};

#endif
