#ifndef MARS_MHillas
#define MARS_MHillas

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

class TEllipse;

class MGeomCam;
class MCerPhotEvt;

class MHillas : public MParContainer
{
private:
    // for description see MHillas.cc
    Float_t   fLength;   // [mm]        major axis of ellipse
    Float_t   fWidth;    // [mm]        minor axis of ellipse
    Float_t   fDelta;    // [rad]       angle of major axis with x-axis
    Float_t   fSize;     // [#CerPhot]  sum of content of all pixels (number of Cherenkov photons)
    Float_t   fMeanx;    // [mm]        x-coordinate of center of ellipse
    Float_t   fMeany;    // [mm]        y-coordinate of center of ellipse

    Float_t   fSinDelta; //! [1] sin of Delta (to be used in derived classes)
    Float_t   fCosDelta; //! [1] cos of Delta (to be used in derived classes)

    TEllipse *fEllipse;  //! Graphical Object to Display Ellipse

protected:
    //
    // This is only for calculations in derived classes because
    // we don't want to read/write this data members
    //
    Float_t GetCosDelta() const { return fCosDelta; }
    Float_t GetSinDelta() const { return fSinDelta; }

public:
    MHillas(const char *name=NULL, const char *title=NULL);
    ~MHillas();

    void Reset();

    virtual Bool_t Calc(const MGeomCam &geom, const MCerPhotEvt &pix);

    virtual void Print(Option_t *opt=NULL) const;
    virtual void Draw(Option_t *opt=NULL);
    //virtual void Paint(Option_t *);

    virtual void Clear(Option_t *opt=NULL);

    Float_t GetLength() const { return fLength; }
    Float_t GetWidth() const  { return fWidth; }
    Float_t GetDelta() const  { return fDelta; }
    Float_t GetSize() const   { return fSize; }
    Float_t GetMeanX() const  { return fMeanx; }
    Float_t GetMeanY() const  { return fMeany; }

    virtual void AsciiRead(ifstream &fin);
    virtual void AsciiWrite(ofstream &fout) const;

    ClassDef(MHillas, 1) // Storage Container for Hillas Parameter
};

#endif
