#ifndef MARS_MH
#define MARS_MH

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

class TH1;
class MBinning;
class MParList;
class TArrayD;
class TAxis;

class TCanvas;

class MH : public MParContainer
{
public:
    MH(const char *name=NULL, const char *title=NULL);

    virtual Bool_t SetupFill(const MParList *pList) { return kTRUE; }
    virtual Bool_t Fill(const MParContainer *par) = 0;

    static TCanvas *MakeDefCanvas(const char *name=NULL, const char *title="",
                                  const UInt_t w=700, const UInt_t h=500);
    static TCanvas *MakeDefCanvas(const TObject *obj,
                                  const UInt_t w=700, const UInt_t h=500);

    static void SetBinning(TH1 *h, const MBinning *binsx);
    static void SetBinning(TH1 *h, const MBinning *binsx, const MBinning *binsy);
    static void SetBinning(TH1 *h, const MBinning *binsx, const MBinning *binsy, const MBinning *binsz);

    static void SetBinning(TH1 *h, const TArrayD *binsx);
    static void SetBinning(TH1 *h, const TArrayD *binsx, const TArrayD *binsy);
    static void SetBinning(TH1 *h, const TArrayD *binsx, const TArrayD *binsy, const TArrayD *binsz);

    static void SetBinning(TH1 *h, const TAxis *binsx);
    static void SetBinning(TH1 *h, const TAxis *binsx, const TAxis *binsy);
    static void SetBinning(TH1 *h, const TAxis *binsx, const TAxis *binsy, const TAxis *binsz);

    ClassDef(MH, 1) //A histogram base class for Mars histograms
};

#endif

