#ifndef MARS_MHHillas
#define MARS_MHHillas

#ifndef MARS_MH
#include "MH.h"
#endif

class TH1F;
class MHillas;

class MHHillas : public MH
{
private:
    TH1F *fWidth;
    TH1F *fLength;

    Float_t fMm2Deg;

    Bool_t fUseMmScale;

public:
    MHHillas(const char *name=NULL, const char *title=NULL);
    ~MHHillas();

    void SetMmScale(Bool_t mmscale=kTRUE) { fUseMmScale = mmscale; }

    Bool_t SetupFill(const MParList *pList);
    Bool_t Fill(const MParContainer *par);

    TH1F *GetHistWidth()  { return fWidth; }
    TH1F *GetHistLength() { return fLength; }

    void Draw(Option_t *opt=NULL);
    TObject *DrawClone(Option_t *opt=NULL) const;

    ClassDef(MHHillas, 1) // Container which holds histograms for length and width
};

#endif
