#ifndef MARS_MHAlphaEnergyTime
#define MARS_MHAlphaEnergyTime

#ifndef MARS_MH
#include "MH.h"
#endif
#ifndef ROOT_TH3
#include "TH3.h"
#endif

class MHillasSrc;
class MEnergyEst;
class MTime;
class TH2D;
class MParList;

class MHAlphaEnergyTime : public MH
{
private:
    MHillasSrc *fHillas; //!
    MEnergyEst *fEnergy; //!
    MTime      *fTime;   //!

    TH3D    fHist;

    void SetAlphaRange(Axis_t lo, Axis_t up);

public:
    MHAlphaEnergyTime(const char *name=NULL, const char *title=NULL);

    virtual Bool_t SetupFill(const MParList *pList);
    virtual Bool_t Fill(const MParContainer *par);

    const TH3D *GetHist()       { return &fHist; }
    const TH3D *GetHist() const { return &fHist; }

    void Draw(Option_t *option="");
    TObject *DrawClone(Option_t *option="") const;

    void Substract(const TH3D *h1, const TH3D *h2);
    void Substract(const MHAlphaEnergyTime *h1, const MHAlphaEnergyTime *h2)
    {
        Substract(h1->GetHist(), h2->GetHist());
    }

    TH2D *GetAlphaProjection(Axis_t lo, Axis_t up);

    ClassDef(MHAlphaEnergyTime, 1) //Histogram to store a 3-Dim histogram in alpha, Energy and time
};

#endif

