#ifndef MARS_MH3
#define MARS_MH3

#ifndef ROOT_TH1
#include <TH1.h>
#endif
#ifndef MARS_MH
#include "MH.h"
#endif

class TH1;
class TMethodCall;
class MDataChain;

class MH3 : public MH
{
protected:
    // Could be const but root < 3.02/06 doesn't like this...
    Int_t fDimension;            // Number of dimensions of histogram
    TH1  *fHist;                 // Histogram to fill

    TString     fDataMember[3];  // Data member which should be filled into the histogram x
    MDataChain *fData[3];        // Object from which the data is filled
    Double_t    fScale[3];

public:
    MH3(const char *memberx);
    MH3(const char *memberx, const char *membery);
    MH3(const char *memberx, const char *membery, const char *memberz);
    ~MH3();

    void SetScaleX(Double_t scale) { fScale[0] = scale; }
    void SetScaleY(Double_t scale) { fScale[1] = scale; }
    void SetScaleZ(Double_t scale) { fScale[2] = scale; }

    Int_t GetDimension() const { return fDimension; }

    void SetName(const char *name);
    void SetTitle(const char *title);

    Bool_t SetupFill(const MParList *pList);
    Bool_t Fill(const MParContainer *par);

    TH1 &GetHist() { return *fHist; }
    const TH1 &GetHist() const { return *fHist; }

    void Draw(Option_t *opt=NULL);
    TObject *DrawClone(Option_t *opt=NULL) const;

    ClassDef(MH3, 1) // Generalized 1/2/3D-histogram for Mars variables
};

#endif
