#ifndef MARS_MHAlphaEnergyTheta
#define MARS_MHAlphaEnergyTheta

#ifndef MARS_MH
#include "MH.h"
#endif

#ifndef ROOT_TH3
#include "TH3.h"
#endif

#ifndef ROOT_TH2
#include "TH2.h"
#endif

class MMcEvt;
class MHillasSrc;
class MEnergyEst;
class TH2D;
class MParList;


class MHAlphaEnergyTheta : public MH
{
private:
    MMcEvt     *fMcEvt;  //!
    MHillasSrc *fHillas; //!
    MEnergyEst *fEnergy; //!

    TH3D fHist;

public:
    MHAlphaEnergyTheta(const char *name=NULL, const char *title=NULL);

    virtual Bool_t SetupFill(const MParList *pList);
    virtual Bool_t Fill(const MParContainer *par);

    const TH3D *GetHist()       { return &fHist; }
    const TH3D *GetHist() const { return &fHist; }

    void Draw(Option_t *option="");
    TObject *DrawClone(Option_t *option="") const;

    void Subtract(const TH3D *h1, const TH3D *h2);
    void Subtract(const MHAlphaEnergyTheta *h1, const MHAlphaEnergyTheta *h2)
    {
        Subtract(h1->GetHist(), h2->GetHist());
    }

    TH2D *DrawAlphaProjection(Axis_t lo, Axis_t up, Option_t *opt="");
    TH2D *GetAlphaProjection(Axis_t lo, Axis_t up);

    ClassDef(MHAlphaEnergyTheta, 1) //3D-histogram in alpha, Energy and theta
};

#endif





