/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz  12/2000 (tbretz@uni-sw.gwdg.de)
!
!   Copyright: MAGIC Software Development, 2000-2001
!
!
\* ======================================================================== */

Bool_t isloaded()
{
    TString str = gSystem->GetLibraries("*/mars.so");

    return !str.IsNull();
}

void unload()
{
    if (!isloaded())
        return;

    cout << "Unloading 'mars.so'... " << flush;
    if (gSystem->Unload("mars.so"))
        cout << "error." << endl;
    else
        cout << "done." << endl << endl;
}

void load()
{
    if (isloaded())
        return;

    cout << "Loading 'mars.so'... " << flush;

    if (gSystem->Load("mars.so")!=0)
        cout << "error." << endl;
    else
    {
        MParContainer::Class()->IgnoreTObjectStreamer();
        MArray::Class()->IgnoreTObjectStreamer();
        cout << "done." << endl;
    }

    cout << endl;
}

void make()
{
    unload();

    if (gSystem->Exec("make"))
    {
        cout << "Error calling make..." << endl;
        return;
    }

    load();
}

void rootlogon()
{
    cout << endl;

    load();

    gInterpreter->AddIncludePath("macros");
    gInterpreter->AddIncludePath("manalysis");
    gInterpreter->AddIncludePath("mbase");
    gInterpreter->AddIncludePath("mdata");
    gInterpreter->AddIncludePath("mfileio");
    gInterpreter->AddIncludePath("mfilter");
    gInterpreter->AddIncludePath("mgui");
    gInterpreter->AddIncludePath("mhist");
    gInterpreter->AddIncludePath("mmain");
    gInterpreter->AddIncludePath("mmc");
    gInterpreter->AddIncludePath("mmontecarlo");
    gInterpreter->AddIncludePath("mraw");

    cout << "Welcome to the Mars Root environment." << endl;

    cout << endl;
}
