#ifndef MARS_MBlindPixelCalc
#define MARS_MBlindPixelCalc

#ifndef MARS_MTask
#include "MTask.h"
#endif

#ifndef ROOT_TArrayS
#include <TArrayS.h>
#endif

class MCerPhotEvt;
class MBlindPixels;

class MBlindPixelCalc : public MTask
{
private:
    MCerPhotEvt  *fEvt;     //!
    MBlindPixels *fPixels;  //!

    TArrayS fPixelsID;  // Pixel IDs for blind pixels, which are entered by the user.

public:
    MBlindPixelCalc(const char *name=NULL, const char *title=NULL);

    Bool_t PreProcess(MParList *pList);
    Bool_t Process();

    void SetPixels(Int_t num, Short_t *ids);
    virtual Bool_t ReInit(MParList *pList);

    ClassDef(MBlindPixelCalc, 0) // task to disable given pixels for analysis
}; 

#endif

