#ifndef MARS_MineSweeper
#define MARS_MineSweeper

#ifndef MARS_MAGIC
#include "MAGIC.h"
#endif
#ifndef ROOT_TClonesArray
#include <TClonesArray.h>
#endif

class TText;
class TMarker;
class TVirtualPad;

class MGeomCam;
class MHexagon;

class MineSweeper : public TObject
{
private:
    MGeomCam      *fGeomCam;       // pointer to camera geometry

    UInt_t         fNumPixels;     // number of pixels in the present geometry
    Int_t          fNumBombs;      // number of bombs in total
    Float_t        fRange;         // the range in millimeters of the present geometry

    TClonesArray  *fPixels;        // array of all hexagons
    TClonesArray  *fText;          // array of all texts
    TClonesArray  *fFlags;         // array of all texts

    TText         *fDone;          // TText showing the 'Game over'
    TText         *fShow;          // TText showing the numbers of pixels and bombs

    Int_t          fColorBombs[7]; // colors for the hexagons

    UInt_t         fW;             // Width of canvas
    UInt_t         fH;             // Height of canvas
    TVirtualPad   *fDrawingPad;    // pad in which we are drawing
    Bool_t         fIsAllocated;

    enum
    {
        kBlack     =  1,      // schwarz
        kWhite     = 10,
        kHidden    = 50,
        kIsVisible = BIT(15),
        kHasBomb   = BIT(16),
        kHasFlag   = BIT(17)
    };

    TText   *GetText(Int_t i) { return (TText*)fText->At(i); }
    TMarker *GetFlag(Int_t i) { return (TMarker*)fFlags->At(i); }

    MHexagon &operator[](int i) { return *((MHexagon*)fPixels->At(i)); }

    void Paint(Option_t *option="");

    void Remove(TObject *);
    void OpenHexagon(Int_t idx);
    void Done(TString, Int_t);
    void Update(Int_t);
    void SetNewCamera(MGeomCam *);
    void DrawHexagons();
    void Free();

public:
    MineSweeper();
    ~MineSweeper();

    virtual Int_t DistancetoPrimitive(Int_t px, Int_t py) { return 0; }
    virtual void  ExecuteEvent(Int_t event, Int_t px, Int_t py);

    void ChangeCamera(); //*MENU*
    void Reset();        //*MENU*

    virtual void Draw(Option_t *option="");

    ClassDef(MineSweeper, 0) // Magic Camera Games
};

#endif
