#ifndef MARS_MFParticleId
#define MARS_MFParticleId

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MFParticleId                                                           //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MFilter
#include "MFilter.h"
#endif

class MMcEvt;
class MParList;

class MFParticleId : public MFilter
{
private:
    const MMcEvt *fMcEvt;
    TString fContName;

    typedef enum { kEEqual, kENotEqual } FilterType_t;
    FilterType_t fFilterType;

    Bool_t fResult;
    Int_t  fValue;

    void Init(const char type, const Int_t val,
              const char *name, const char *title);

public:
    MFParticleId(const char *cname="MMcEvt", const char type='=', const Int_t val=0,
                 const char *name=NULL, const char *title=NULL);
    MFParticleId(const MMcEvt *mcevt, const char type='=', const Int_t val=0,
                 const char *name=NULL, const char *title=NULL);

    Bool_t IsExpressionTrue() const;
    Bool_t PreProcess(MParList *pList);
    Bool_t Process();

    ClassDef(MFParticleId, 0)		// A Filter for the Level 1 Trigger
};

#endif
