#ifndef MARS_MCerPhotCalc2
#define MARS_MCerPhotCalc2

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MCerPhotCalc2                                                           //
//                                                                         //
// Integrates certain time slices of one pixel and substracts the pedestal //
// (offset) value                                                          //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MTask
#include "MTask.h"
#endif

#include <TArrayF.h>

class MRawEvtData;
class MPedestalCam;
class MCerPhotEvt;
class MRawRunHeader;
class TArrayF;

class MCerPhotCalc2 : public MTask
{
    MPedestalCam   *fPedestals;  // Pedestals of all pixels in the camera
    MRawEvtData    *fRawEvt;     // raw event data (time slices)
    MCerPhotEvt    *fCerPhotEvt; // Cerenkov Photon Event used for calculation
    MRawRunHeader  *fRunHeader;  // RunHeader information
 
    Bool_t          fEnableFix;  // fix for a bug in files from older camera versions (<=40)

    TArrayF         fWeight;  // Weights for adding up the ADC slices
    Float_t         fSumQuadWeights;

    void SetDefaultWeights();

public:
    MCerPhotCalc2(const char *name=NULL, const char *title=NULL);

    Bool_t PreProcess(MParList *pList);
    Bool_t Process();
    Bool_t ReInit(MParList *pList);

    void   SetWeights(TArrayF w) {fWeight.Set(w.GetSize(),w.GetArray());}

    ClassDef(MCerPhotCalc2, 0)   // Task to calculate cerenkov photons from raw data
};
 

#endif
