#ifndef MARS_MReadTree
#define MARS_MReadTree

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MChain;
class TBranch;
class TGProgressBar;

class MReadTree : public MTask
{
private:
    MChain *fChain;            // Pointer to tree

    UInt_t  fNumEntry;         // Number of actual entry in chain
    UInt_t  fNumEntries;       // Number of Events in chain

    Bool_t  fBranchChoosing;   // Flag for branch choosing method
    Bool_t  fAutoEnable;       // Flag for auto enabeling scheme

    TList  *fVetoList;         // List of Branches which are not allowed to get enabled
    TList  *fNotify;           // List of TObjects to notify when switching files

private:
    TGProgressBar  *fProgress; //! Possible display of status

    void SetBranchStatus(const TList *list, Bool_t status);
    void SetBranchStatus(TObject *branch, Bool_t status);
    void SetBranchStatus(const char *name, Bool_t status);

    void DisableSubBranches(TBranch *b);
    void EnableBranches(MParList *plist);
    void EnableBranchChoosing();

    virtual void SetReadyToSave(Bool_t flag=kTRUE);
    virtual void StreamPrimitive(ofstream &out) const;

    enum { kIsOwner = BIT(14) };

public:
    MReadTree();
    MReadTree(const char *treename, const char *filename=NULL, const char *name=NULL, const char *title=NULL);
    ~MReadTree();

    void   DisableAutoScheme() { fAutoEnable = kFALSE; }
    void   EnableBranch(const char *name);
    void   VetoBranch(const char *name);

    void   SetProgressBar(TGProgressBar *bar) { fProgress = bar; }

    Bool_t GetEvent();

    Bool_t DecEventNum(UInt_t dec=1); // decrease number of event (position in tree)
    Bool_t IncEventNum(UInt_t inc=1); // increase number of event (position in tree)
    Bool_t SetEventNum(UInt_t nr);    // set number of event (position in tree)

    UInt_t GetEventNum() const { return fNumEntry;   }
    UInt_t GetEntries() const  { return fNumEntries; }

    TString GetFileName() const;
    Int_t   GetFileIndex() const;

    virtual void   AddNotify(TObject *obj);
    virtual void   SetOwner(Bool_t flag=kTRUE);
    virtual void   Print(Option_t *opt="") const;

    virtual Int_t  AddFile(const char *fname);

    virtual Bool_t PreProcess(MParList *pList);
    virtual Bool_t Process();

    virtual Bool_t Notify();

    ClassDef(MReadTree, 1)	// Reads a tree from file(s)
};

#endif
