/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz  08/2002 <mailto:tbretz@uni-sw.gwdg.de>
!
!   Copyright: MAGIC Software Development, 2000-2002
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//
//   MDataArray
//
/////////////////////////////////////////////////////////////////////////////
#include "MDataArray.h"

#include <fstream.h>

#include "MLog.h"
#include "MLogManip.h"

#include "MDataChain.h"

ClassImp(MDataArray);

static const TString gsDefName  = "MDataArray";
static const TString gsDefTitle = "Array to store MData cntainers";

MDataArray::MDataArray(const char *name, const char *title)
{
    fName  = name  ? name  : gsDefName.Data();
    fTitle = title ? title : gsDefTitle.Data();
}

void MDataArray::AddEntry(const TString rule)
{
    TObject *obj = new MDataChain(rule);
    obj->SetBit(kCanDelete);
    fList.Add(obj);
}

MData &MDataArray::operator[](Int_t i) const
{
    return (MData&)*((TObjArray)fList)[i];
}

Double_t MDataArray::operator()(Int_t i)
{
    return ((MData*)fList[i])->GetValue();
}

Bool_t MDataArray::PreProcess(const MParList *plist)
{
    if (fList.GetSize()==0)
    {
        *fLog << err << "Error - No Column specified... aborting." << endl;
        return kFALSE;
    }

    TIter Next(&fList);
    MData *data = NULL;
    while ((data=(MData*)Next()))
        if (!data->PreProcess(plist))
            return kFALSE;

    return kTRUE;
}

void MDataArray::Print(Option_t *opt) const
{
    Int_t n=0;

    TIter Next(&fList);
    MData *data = NULL;
    while ((data=(MData*)Next()))
    {
        *fLog << all << " Line " << setw(3) << n++ << ": " << flush;
        data->Print();
        *fLog << endl;
    }
}

Bool_t MDataArray::AsciiWrite(ostream &out) const
{
    ((TObjArray)fList).ForEach(MParContainer, AsciiWrite)(out);
    return kTRUE;
}

void MDataArray::StreamPrimitive(ofstream &out) const
{
    out << "   MDataArray " << GetUniqueName();

    if (fName!=gsDefName)
    {
        out << "(\"" << fName << "\"";
        if (fTitle!=gsDefTitle)
            out << ", \"" << fTitle << "\")";
    }
    out << ";" << endl;

    TIter Next(&fList);
    MData *data = NULL;
    while ((data=(MData*)Next()))
        out << "   " << GetUniqueName() << ".AddEntry(\"" << data->GetRule() << "\");" << endl;
}
