#ifndef MARS_MBlindPixelCalc
#define MARS_MBlindPixelCalc

#ifndef MARS_MTask
#include "MTask.h"
#endif

#ifndef ROOT_TArrayS
#include <TArrayS.h>
#endif

class MGeomCam;
class MCerPhotEvt;
class MBlindPixels;

class MBlindPixelCalc : public MTask
{
private:
    MCerPhotEvt  *fEvt;     //!
    MBlindPixels *fPixels;  //!
    MGeomCam     *fGeomCam; //!

    TArrayS fPixelsID;  // Pixel IDs for blind pixels, which are entered by the user.

    Byte_t fFlags;      // flag for the method which is used

    enum
    {
        kUseInterpolation = 1,
        kUseCentralPixel  = 2
    };

    void Interpolate() const;
    void Unmap() const;
    void StreamPrimitive(ofstream &out) const;

public:
    MBlindPixelCalc(const char *name=NULL, const char *title=NULL);

    void SetUseInterpolation(Bool_t b=kTRUE)
    {
        b ? SETBIT(fFlags, kUseInterpolation) : CLRBIT(fFlags, kUseInterpolation);
    }
    void SetUseCentralPixel(Bool_t b=kTRUE)
    {
        b ? SETBIT(fFlags, kUseCentralPixel) : CLRBIT(fFlags, kUseCentralPixel);
    }

    Bool_t PreProcess(MParList *pList);
    Bool_t Process();

    void SetPixels(Int_t num, Short_t *ids);
    void SetPixels(const TArrayS pix) { SetPixels(pix.GetSize(), pix.GetArray()); }
    virtual Bool_t ReInit(MParList *pList);

    ClassDef(MBlindPixelCalc, 1) // task to deal with hot spots (star, broken pixels, etc)
}; 

#endif

