#ifndef MARS_MMultiDimDistCalc
#define MARS_MMultiDimDistCalc

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MHMatrix;
class MParList;
class MDataArray;
class MHadronness;

class MMultiDimDistCalc : public MTask
{
private:
    Int_t  fNum;              // number of distances used for an avarage
    Bool_t fUseKernel;        // Flag whether kernel method should be used

    MHMatrix   *fMGammas;     //! Gammas describing matrix
    MHMatrix   *fMHadrons;    //! Hadrons (non gammas) describing matrix

    MHadronness *fHadronness; //! Output container for calculated hadroness

    MDataArray *fData;        //! Used to store the MDataChains to get the event values

    void StreamPrimitive(ofstream &out) const;

public:
    MMultiDimDistCalc(const char *name=NULL, const char *title=NULL);
    ~MMultiDimDistCalc();

    void SetUseNumRows(UShort_t n=0) { fNum = n; }
    void SetUseKernelMethod(Bool_t k=kTRUE) { fUseKernel = k; }

    Bool_t PreProcess(MParList *plist);
    Bool_t Process();

    ClassDef(MMultiDimDistCalc, 0) // Task to calculate multidimensional distances
};

#endif
