#ifndef MARS_MAGIC
#define MARS_MAGIC
///////////////////////////////////////////////////////////////////////////////
//
//     Magic.h
//
//     defines MAGIC base informations
//
///////////////////////////////////////////////////////////////////////////////

#ifndef ROOT_TROOT
#include <TROOT.h>
#endif

//
// Values for the eventloop control
//
const Int_t kCONTINUE = 2;
const Int_t kSKIP     = 2;
const Int_t kERROR    = 3;

//
//     ParticleId for Monte Carlo simulation
//
typedef enum
{
    kGAMMA  =    1,
    kPROTON =   14,
    kHELIUM =  402,
    kOXYGEN = 1608,
    kIRON   = 5626
} ParticleId_t;

const Double_t kRad2Deg = 180.0/3.1415926535897932384626433832795028841971693993751;

//
// This is the definition of a global output stream, which by
// default pipes all output to the stdout
//

#ifdef __LINUX__
class MLog;
#else
#include "MLog.h"
#endif

extern MLog gLog;

#endif
