/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Robert Wagner  10/2002 <mailto:magicsoft@rwagner.de>
!
!   Copyright: MAGIC Software Development, 2002
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MObservatoryLocation                                                    //
//                                                                         //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////
#include "MObservatoryLocation.h"

#include <TMath.h>

#include "MLog.h"
#include "MLogManip.h"

ClassImp(MObservatoryLocation);

MObservatoryLocation::MObservatoryLocation(const char *name, const char *title)
{
    fName  = name  ? name  : "MObservatoryLocation";
    fTitle = title ? title : "Storage container for coordinates of an observatory";   
    //    TH1F fHorizon=new TH1F;   
    fgDegToRad=2*TMath::Pi()/360;    
    fLatitude  =  28.7594 * fgDegToRad; // rad; 28 45 34
    fLongitude =  17.8761 * fgDegToRad; // rad; 17 52 34;
                                        // slalib uses + for WEST !!!
    fElevation = 2300; // m
    fObsName = "Observatorio del Roque de los Muchachos";
}

//Double_t GetHorizon(Double_t phi);
//TF1 SetHorizonLine() { return fHorizon; }
//TF1 GetHorizonLine() { return fHorizon; }

MObservatoryLocation::~MObservatoryLocation()
{
  // do nothing special.
}

void MObservatoryLocation::Print(Option_t *) const
{
  *fLog << all;
  *fLog << fObsName << endl;
  *fLog << "Latitude " << (fLatitude > 0 ? (fLatitude/fgDegToRad) : -(fLatitude/fgDegToRad)) << " deg " << (fLatitude > 0 ? "W" : "E") << endl;
  *fLog << "Longitude " << (fLongitude > 0 ? (fLongitude/fgDegToRad) : -(fLongitude/fgDegToRad)) <<" deg " << (fLongitude < 0 ? "N" : "S") << endl;
  *fLog << "Elevation " << fElevation << "m" << endl;
}
