#ifndef MARS_MObservatoryLocation
#define MARS_MObservatoryLocation

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

class MObservatoryLocation : public MParContainer
{
private:
  char* fObsName;
  Double_t fLatitude;
  Double_t fLongitude;
  Double_t fElevation;
  Double_t fgDegToRad;
  //  TH1F     fHorizon;

public:
  MObservatoryLocation(const char *name=NULL, const char *title=NULL);
  ~MObservatoryLocation();

  inline void SetLatitude(Double_t latitude) { fLatitude = latitude; }
  inline void SetLongitude(Double_t longitude) { fLongitude = longitude; }
  inline void SetElevation(Double_t elevation) { fElevation = elevation; }
  inline void SetObservatoryName(char* name) { fObsName = name; }
  
  void MObservatoryLocation::Print(Option_t *) const;
  
  inline Double_t GetLatitude() { return fLatitude/fgDegToRad; }
  inline Double_t GetLongitude() { return fLongitude/fgDegToRad; }
  inline Double_t GetElevation() { return fElevation; }
  Double_t GetLatitudeRad() { return fLatitude; }
  Double_t GetLongitudeRad() { return fLongitude; }
  char* GetObservatoryName() { return fObsName; }
  // Double_t GetHorizon(Double_t phi);
  // void SetHorizonLine(TF1 hor) { fHorizon = hor; }
  // TH1F GetHorizonLine() { return fHorizon; }
  
  ClassDef(MObservatoryLocation, 1)

};

#endif

