#ifndef MARS_MSelFinal
#define MARS_MSelFinal

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MSelFinal                                                               //
//                                                                         //
// Task to evaluate final cuts                                             //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MGeomCam;
class MCerPhotEvt;
class MHillas;
class MHillasSrc;
class MMcEvt;
class MHadronness;

class MSelFinal : public MTask
{
private:
    MGeomCam    *fCam;      // Camera Geometry 
    MCerPhotEvt *fEvt;      // Cerenkov Photon Event 
    MMcEvt      *fMcEvt;       
    MHillas     *fHil;       
    MHillasSrc  *fHilSrc;       
    MHadronness *fHadronness;       

    Double_t     fMm2Deg;   // conversion mm to degrees in camera
    Int_t        fCut[3];
    TString      fHilName;
    TString      fHilSrcName;
 
    Float_t      fHadronnessMax;
    Float_t      fAlphaMax;

public:
    MSelFinal(const char *HilName="MHillas", const char *HilSrcName="MHillasSrc",
              const char *name=NULL, const char *title=NULL);

    Bool_t PreProcess(MParList *pList);
    Bool_t Process();
    Bool_t PostProcess();

    void SetCuts(Float_t hadmax, Float_t alphamax) 
         { fHadronnessMax = hadmax; fAlphaMax = alphamax;  }

    ClassDef(MSelFinal, 0)   // Task to evaluate final cuts
};

#endif











