#ifndef MARS_MMcPedestalNSBAdd
#define MARS_MMcPedestalNSBAdd

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MMcFadcHeader;
class MGeomCam;
class MPedestalCam;

class MMcPedestalNSBAdd : public MTask
{
private:
    const MGeomCam *fGeom;
    MMcFadcHeader  *fFadc;
    MPedestalCam   *fPedCam;

    Float_t fDnsbPixel;

    Bool_t CheckRunType(MParList *pList) const;
    Float_t GetDnsb(MParList *pList) const;

public:
    MMcPedestalNSBAdd(const Float_t difnsb = -1.0,
                      const char *name=NULL, const char *title=NULL);

    Bool_t PreProcess(MParList *pList);

    virtual Bool_t ReInit(MParList *pList);

    ClassDef(MMcPedestalNSBAdd, 0)   // Task which adds the NSB fluctuations to the pedestals rms
};

#endif
