#ifndef MARS_MPadding
#define MARS_MPadding

#ifndef MARS_MTask
#include "MTask.h"
#endif

#ifndef MARS_MH
#include "MH.h"
#endif

#include "TRandom3.h"
#include "TH1.h"
#include "TH2.h"
#include "TH3.h"
#include "TProfile.h"


class MGeomCam;
class MCerPhotEvt;
class MPedestalCam;
class MMcEvt;
class MPedestalCam;
class MSigmabar;
class MParList;

class MPadding : public MTask
{
private:
    MGeomCam *fCam; 
    MCerPhotEvt    *fEvt; 
    MSigmabar      *fSigmabar;
    MMcEvt         *fMcEvt;
    MPedestalCam   *fPed;

    TRandom3       *fRnd;

    Int_t          fRunType;
    Int_t          fGroup;

    TH1D           *fHSigmabarMax;   // histogram (sigmabarmax vs. Theta)
    char           *fDatabaseFilename; // data file used for generating
                                     //   fHSigmabarMax histogram

    TH2D           *fHSigmaTheta;    // 2D-histogram (sigmabar vs. Theta)

    Double_t       fFixedSigmabar;   // fixed sigmabar value

    TH2D           *fHSigmaPedestal; // for testing : plot of padded vs
                                     //               orig. pedestal sigmas
    TH2D           *fHPhotons;       // for testing : no.of photons after
                                     //               versus before padding
    TH2D           *fHSigmaOld;      // histogram (sigma vs. Theta)
                                     // before padding

    TH2D           *fHSigmaNew   ;   // histogram (sigma vs. Theta)
                                     // after padding
    TH1D           *fHNSB;           // histogram of added NSB


public:
    MPadding(const char *name=NULL, const char *title=NULL);
    ~MPadding();

    Bool_t PreProcess(MParList *pList);
    Bool_t Process();
    Bool_t PostProcess();
    
    Bool_t Padding(Double_t quadDiff);

    void SetRunType(Int_t runtype) { fRunType =  runtype; }
    void SetGroup(Int_t group)     { fGroup   =  group; }

    Bool_t SetDefiningHistogram(TH1D *hist);
    void SetDatabaseFile(char *filename) { fDatabaseFilename = filename; }

    Bool_t SetSigmaThetaHist(TH2D *histo);

    void SetTargetLevel(Double_t sigmabar);

    ClassDef(MPadding, 1)    // task for the padding
}; 

#endif



