#ifndef MARS_MSigmabar
#define MARS_MSigmabar

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

#ifndef MARS_MParList
#include "MParList.h"
#endif

#ifndef MARS_MGeomCam
#include "MGeomCam.h"
#endif

#ifndef MARS_MPedestalCam
#include "MPedestalCam.h"
#endif

class MCerPhotEvt;

class MSigmabar : public MParContainer
{
private:
    Float_t fSigmabar;          // Sigmabar ("average" RMS) of pedestal
    Float_t fSigmabarInner;     // --only for inner pixels
    Float_t fSigmabarOuter;     // --only for outer pixels  

    Float_t fSigmabarSector[6]; // --for the 6 sectors of the camera
    Float_t fSigmabarInnerSector[6];
    Float_t fSigmabarOuterSector[6];

    UInt_t  fInnerPixels;       // Overall number of inner pixels
    UInt_t  fOuterPixels;       // Overall number of outer pixels

    Bool_t  fCalcPixNum;
    
public:

    MSigmabar(const char *name=NULL, const char *title=NULL);
    ~MSigmabar();
    
    void Print(Option_t *) const;
 
    Float_t GetSigmabar() const       { return fSigmabar;       }
    Float_t GetSigmabarInner() const  { return fSigmabarInner;  }
    Float_t GetSigmabarOuter() const  { return fSigmabarOuter;  }
    Float_t GetSigmabarSector(const Int_t sector) const 
                              { return fSigmabarSector[sector]; } 
  
    //   void SetSigmabar(Float_t f, Float_t i, Float_t o) 
    //      { fSigmabar = f; fSigmabarInner = i; fSigmabarOuter = o; }
    //    void SetSigmabarInner(Float_t f) { fSigmabarInner = f; }
    //    void SetSigmabarOuter(Float_t f) { fSigmabarOuter = f; }   

    Float_t Calc(const MGeomCam &geom, const MPedestalCam &ped, const MCerPhotEvt &evt);
      
    ClassDef(MSigmabar, 1)  // Storage Container for Sigmabar
};

#endif





