#ifndef MARS_MHHillasExt
#define MARS_MHHillasExt

#ifndef ROOT_TH1
#include <TH1.h>
#endif
#ifndef MARS_MH
#include "MH.h"
#endif

class MHillasExt;

class MHHillasExt : public MH
{
private:
    MHillasExt *fHillasExt; //! Pointer to the MHillasExt container

    TH1F fHConc;    // [ratio] concentration ratio: sum of the two highest pixels / fSize
    TH1F fHConc1;   // [ratio] concentration ratio: sum of the highest pixel / fSize
    TH1F fHAsym;    // [mm]    fDist minus dist: center of ellipse, highest pixel
    TH1F fHM3Long;  // [mm]    3rd moment (e-weighted) along major axis
    TH1F fHM3Trans; // [mm]    3rd moment (e-weighted) along minor axis

    Float_t fMm2Deg;
    Bool_t  fUseMmScale;

    TString fHilName;

public:
    //MHHillasExt(const char *name=NULL, const char *title=NULL);
    MHHillasExt(const char *name=NULL, const char *title=NULL,
                const char *hil="MHillas");

    ~MHHillasExt();

    void SetMmScale(Bool_t mmscale=kTRUE);
    virtual void SetMm2Deg(Float_t mmdeg);

    Bool_t SetupFill(const MParList *pList);
    Bool_t Fill(const MParContainer *par);

    TH1 *GetHistByName(const TString name);

    void Draw(Option_t *opt=NULL);
    TObject *DrawClone(Option_t *opt=NULL) const;

    ClassDef(MHHillasExt, 1) // Container which holds histograms for the extended hillas parameters
};

#endif
