#ifndef MARS_MVPObject
#define MARS_MVPObject

#ifndef MARS_MTask
#include "MTask.h"
#endif

#ifndef MARS_MObservatoryLocation
#include "MObservatoryLocation.h"
#endif

#ifndef MARS_MVPTime
#include "MVPTime.h"
#endif

class MVPObject : public MTask
{
private:
  MObservatoryLocation *fObservatory;  

  Double_t fRA;
  Double_t fDec;
  Double_t fAlt;
  Double_t fAz;
  Double_t fZA;
  Double_t fDiameter;
  Double_t fEcLat;
  Double_t fEcLong;
  Bool_t fCalcEc;

  Double_t fUT1;
  MVPTime *fTime;
 
  char* fObjectName;
  UInt_t fBody;

  Double_t UT1ToGMST(Double_t ut1);
 
  Double_t fgDegToRad;
  Double_t fgHrsToRad;

  Bool_t fGotRA;
  Bool_t fGotDec;
  Bool_t fGotName;

public:

  MVPObject(const char *name=NULL, const char *title=NULL);
  ~MVPObject();

  Bool_t PreProcess(MParList *pList);
  Bool_t Process();

  void SetObservatory(MObservatoryLocation *observatory);

  void SetRA(Double_t rad) { fRA = rad; fBody = 10; fGotRA = kTRUE; }
  void SetDec(Double_t rad) { fDec = rad; fBody = 10; fGotDec = kTRUE; }

  void SetRA(Int_t rh, Int_t rm, Int_t rs, Int_t ru = 0);
  void SetDec(Int_t dh, Int_t dm, Int_t ds, Int_t du = 0);

  void SetCalcEc(Bool_t calcEc) { fCalcEc = calcEc; }

  void SetObjectName(char* name) { fObjectName = name; fGotName = kTRUE; } 
  void SetObjectByName(char* object);

  Bool_t SetObject(UInt_t body);

  Double_t GetRA() { return fRA/fgHrsToRad; }
  Double_t GetDec() { return fDec/fgDegToRad; }

  Double_t GetRARad()  { return fRA; }
  Double_t GetDecRad() { return fDec; }

  Double_t GetZA() { return fZA; }
  Double_t GetAltitude() { return fAlt; }
  Double_t GetAzimut() { return fAz; }
  Double_t GetDiameter() { return fDiameter; }

  Double_t GetEcLat() { return fEcLat; }
  Double_t GetEcLong() { return fEcLong; }

  Double_t GetZADeg() { return fZA/fgDegToRad; }
  Double_t GetAltitudeDeg() { return fAlt/fgDegToRad; }
  Double_t GetAzimutDeg() { return fAz/fgDegToRad; }

  Double_t GetDistance(MVPObject* object);
  Double_t GetDistanceRad(MVPObject* object);

  char* GetObjectName() { return fObjectName; }
  
  void Print(Option_t *) const;

  Double_t MJDStartOfYear(UInt_t year);

  ClassDef(MVPObject, 1)
}; 

#endif

