#ifndef MARS_MParameters
#define MARS_MParameters

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

class MParameterD : public MParContainer
{
private:
    Double_t fVal;

public:
    MParameterD(const char *name=NULL, const char *title=NULL);

    void SetVal(Double_t v) { fVal = v; }
    Double_t GetVal() const { return fVal; }

    ClassDef(MParameterD, 1) // Container to hold a generalized parameters (double)
};

class MParameterI : public MParContainer
{
private:
    Int_t fVal;

public:
    MParameterI(const char *name=NULL, const char *title=NULL);

    void SetVal(Int_t v) { fVal = v; }
    Int_t GetVal() const { return fVal; }

    ClassDef(MParameterI, 1) // Container to hold a generalized parameters (double)
};

#endif
