#ifndef MARS_MFCT1SelStandard
#define MARS_MFCT1SelStandard

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MFCT1SelStandard                                                        //
//                                                                         //
// Class to evaluate standard cuts                                         //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MFilter
#include "MFilter.h"
#endif

class MGeomCam;
class MCerPhotEvt;
class MHillas;
class MHillasSrc;
class MMcEvt;

class MFCT1SelStandard : public MFilter
{
private:
    MGeomCam    *fCam;      // Camera Geometry 
    MCerPhotEvt *fEvt;      // Cerenkov Photon Event 
    MMcEvt      *fMcEvt;       
    MHillas     *fHil;       
    MHillasSrc  *fHilSrc;       

    Double_t     fMm2Deg;   // conversion mm to degrees in camera
    Int_t        fCut[5];
    TString      fHilName;
    TString      fHilSrcName; 

    Float_t     fUsedPixelsMax;
    Float_t     fCorePixelsMin;
    Float_t     fSizeMin;
    Float_t     fDistMin;
    Float_t     fDistMax;
    Float_t     fLengthMin;
    Float_t     fWidthMin;

    Bool_t      fResult;

public:
    MFCT1SelStandard(const char *HilName="MHillas", const char *HilSrcName="MHillasSrc",
                 const char *name=NULL, const char *title=NULL);

    Bool_t IsExpressionTrue() const  { return fResult; }

    Bool_t PreProcess(MParList *pList);
    Bool_t Process();
    Bool_t PostProcess();

    void SetCuts(Float_t usedpixelsmax, Float_t corepixelsmin,
                 Float_t sizemin, Float_t distmin, Float_t distmax,
                 Float_t lengthmin, Float_t widthmin);

    ClassDef(MFCT1SelStandard, 0)   // Class to evaluate standard cuts
};

#endif











