#ifndef MARS_MFCT1Supercuts
#define MARS_MFCT1Supercuts

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MFCT1Supercuts                                                          //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MFilter
#include "MFilter.h"
#endif

class MParList;
class MHillas;
class MHillasSrc;
class MMcEvt;
class MCerPhotEvt;
class MGeomCam;


class MFCT1Supercuts : public MFilter
{
private:
    MHillas     *fHil;
    MHillasSrc  *fHilSrc;
    MMcEvt      *fMcEvt;
    MCerPhotEvt *fEvt;
    MGeomCam    *fCam;   

    TString     fHilName;
    TString     fHilSrcName;

    Double_t    fMm2Deg;

    Bool_t      fResult; //!

    //---------------------------------
    // cut parameters
    Double_t fLengthUp[8];
    Double_t fWidthUp[8];
    Double_t fDistUp[8];
    Double_t fLengthLo[8];
    Double_t fWidthLo[8];
    Double_t distlow[8];
    Double_t fAsymUp[8];
    Double_t fAsymLo[8];
    Double_t fAlphaUp[8];
    //---------------------------------

    void InitParams();

public:
    MFCT1Supercuts(const char *hilname="MHillas", 
                   const char *hilsrcname="MHillasSrc",
                   const char *name=NULL, const char *title=NULL);

    Double_t CtsMCut(Double_t *a, Double_t ls, Double_t ct, 
                     Double_t ls2, Double_t dd2);

    Bool_t IsExpressionTrue() const { return fResult; }
    Bool_t PreProcess(MParList *pList);
    Bool_t Process();

    ClassDef(MFCT1Supercuts, 1) // A class to evaluate the Supercuts
};

#endif





