#ifndef MARS_MHNewImagePar
#define MARS_MHNewImagePar

#ifndef MARS_MH
#include "MH.h"
#endif

class TH1F;
class MHillas;

class MHNewImagePar : public MH
{
private:
    TH1F *fLeakage1;     //->
    TH1F *fLeakage2;     //->

    Float_t fMm2Deg;
    Bool_t  fUseMmScale;

public:
    MHNewImagePar(const char *name=NULL, const char *title=NULL);
    ~MHNewImagePar();

    void SetMmScale(Bool_t mmscale=kTRUE);
    void SetMm2Deg(Float_t mmdeg);

    Bool_t SetupFill(const MParList *pList);
    Bool_t Fill(const MParContainer *par);

    TH1 *GetHistByName(const TString name);

    TH1F *GetHistLeakage1()         { return fLeakage1; }
    TH1F *GetHistLeakage2()         { return fLeakage2; }

    void Draw(Option_t *opt=NULL);
    TObject *DrawClone(Option_t *opt=NULL) const;

    ClassDef(MHNewImagePar, 1) // Container which holds histograms for the new image parameters
};

#endif


