#ifndef MARS_MTaskList
#define MARS_MTaskList

///////////////////////////////////////////////////////////////////////
//                                                                   //
// MTaskList                                                         //
//                                                                   //
// Collection of tasks to be processed in the eventloop              //
//                                                                   //
///////////////////////////////////////////////////////////////////////

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MLog;
class MParList;
class MInputStreamID;

class MTaskList : public MTask
{
private:
    static const TString gsDefName;  // default name
    static const TString gsDefTitle; // default title

    TList    *fTasks;        // Container for the ordered list of different tasks
    TList     fTasksProcess; //! Task which overload the Process function
    MParList *fParList;      //! The parameter list given in PreProcess

    enum { kIsOwner = BIT(14) };

    void   Remove(MTask *task);
    Bool_t CheckClassForProcess(TClass *cls);

    void StreamPrimitive(ofstream &out) const;

    Bool_t CheckAddToList(MTask *task, const char *tType, const MTask *where=NULL) const;

public:
    MTaskList(const char *name=NULL, const char *title=NULL);
    MTaskList(MTaskList &ts);

    ~MTaskList();

    void SetLogStream(MLog *log);
    void SetDisplay(MStatusDisplay *d);

    Bool_t AddToListBefore(MTask *task, const MTask *where, const char *tType="All");
    Bool_t AddToListAfter(MTask *task, const MTask *where, const char *tType="All");
    Bool_t AddToList(MTask *task, const char *tType="All");

    Bool_t RemoveFromList(MTask *task);

    TObject *FindObject(const char *name) const;
    TObject *FindObject(const TObject *obj) const;

    Bool_t ReInit(MParList *pList=NULL);

    Bool_t PreProcess(MParList *pList);
    Bool_t Process();
    Bool_t PostProcess();

    void Print(Option_t *opt = "") const;
    void PrintStatistics(const Int_t lvl=0, Bool_t title=kFALSE) const;
    void SetOwner(Bool_t enable=kTRUE);

    const TList *GetList() const { return fTasks; }

    void GetNames(TObjArray &arr) const;
    void SetNames(TObjArray &arr);

    Bool_t ReadEnv(const TEnv &env, TString prefix, Bool_t print=kFALSE);
    Bool_t WriteEnv(TEnv &env, TString prefix, Bool_t print=kFALSE) const;

    ClassDef(MTaskList, 1) //collection of tasks to be performed in the eventloop
};

#endif
