#ifndef MARS_MHBlindPixels
#define MARS_MHBlindPixels

#ifndef MARS_MH
#include "MH.h"
#endif
#ifndef ROOT_TH1
#include <TH1.h>
#endif

class MHBlindPixels : public MH
{
private:
    TH1D fHist; //

public:
    MHBlindPixels(const char *name=NULL, const char *title=NULL);

    const TH1D *GetHist()       { return &fHist; }
    const TH1D *GetHist() const { return &fHist; }

    TH1 *GetHistByName(const TString name) { return &fHist; }

    void Draw(Option_t* option = "");
    Bool_t Fill(const MParContainer *par);

    ClassDef(MHBlindPixels, 1)  // Histogram of blind pixels
};

#endif
