#ifndef MARS_MHCerPhotEvt
#define MARS_MHCerPhotEvt

#ifndef MARS_MH
#include "MH.h"
#endif

#ifndef MARS_MCerPhotEvt
#include "MCerPhotEvt.h"
#endif

class TH1D;
class MGeamCam;
class MCamDisplay;

class MHCerPhotEvt : public MH
{
private:
    MCerPhotEvt  fSum;
    Int_t        fEntries;
    MCerPhotEvt *fEvt;   //!
    MGeomCam    *fCam; 
    MCamDisplay *fDispl; //!

public:
    MHCerPhotEvt(const char *name=NULL, const char *title=NULL);
    ~MHCerPhotEvt();

    //    TObject *Clone(const char *newname="") const;

    void Clear();

    Bool_t SetupFill(const MParList *pList);
    Bool_t Fill(const MParContainer *par);
    Bool_t Finalize();

    TH1 *GetHistByName(const TString name) { return NULL; }

    const MCerPhotEvt &GetSum() const { return fSum; }

    TObject *DrawClone(Option_t *opt) const;
    void Draw(Option_t *);
    void Paint(Option_t *option="");

    ClassDef(MHCerPhotEvt, 1) // Histogram to sum camera events
};

#endif
