#include <TSystem.h>

#include "TFile.h"
#include "TTree.h"
#include "TBranch.h"

#include "MParList.h"
#include "MTaskList.h"
#include "MEvtLoop.h"

#include "MLog.h"
#include "MTime.h"
#include "MRawRunHeader.h"
#include "MRawEvtHeader.h"
#include "MRawEvtData.h"
#include "MRawCrateArray.h"
#include "MInputStreamID.h"

#include "MMcEvt.hxx"
#include "MMcTrig.hxx"

/////////////////////////////////////////////////////////////////////////////
//
// This is an demonstration how to read in a merpped root file
//
/////////////////////////////////////////////////////////////////////////////

void EnableBranch(TTree *t, TString name, void *ptr)
{
    if (!t->GetBranch(name+"."))
        return;

    t->GetBranch(name+".")->SetAddress(ptr);
    gLog << " Found '" << name << "'" << endl;
}

int main(const int argc, const char **argv)
{
    gLog << "==================================================" << endl;
    gLog << "                   ReadRaw v0.1                   " << endl;
    gLog << "       MARS - Read and print raw data file        " << endl;
    gLog << "            Compiled on <" << __DATE__ << ">" << endl;
    gLog << "==================================================" << endl;
    gLog << endl;

    //
    // check for the right usage of the program
    //
    if (argc!=2)
    {
        gLog << "Sorry the usage is:" << endl;
        gLog << "   readraw inputfile" << endl << endl;
        return -1;
    }

    //
    //     initialize ROOT  (this is obligatory here)
    //
    TROOT simple("readraw","Mars - Read and print raw data file");

    //
    // check whether the given files are OK.
    //
    if (gSystem->AccessPathName(argv[1], kFileExists))
    {
        gLog << "Sorry, the file '" << argv[1] << "' doesn't exist." << endl;
        return -1;
    }

    //
    //  open the file
    //
    gLog << " Open the file '" << argv[1] << "'" << endl;
    TFile input(argv[1], "READ");

    //
    // open the Run Header and read in
    //
    gLog << " Check for Tree 'RunHeaders'" << endl;
    TTree *runtree = (TTree*)input.Get("RunHeaders");
    if (!runtree)
        gLog << " WARNING: This file has NO Tree 'RunHeaders'" << endl << endl;
    else
    {
        gLog << " Entries in Tree RunHeaders: " << dec << runtree->GetEntries() << endl;

        MRawRunHeader *runheader = NULL;
        runtree->GetBranch("MRawRunHeader")->SetAddress(&runheader);
        runtree->GetEvent(0);
        runheader->Print();
    }

    //
    // open the DataTree and read in 
    //
    gLog << " Check the Tree 'Events'" << endl ;
    TTree *evttree = (TTree*)input.Get("Events") ;
    if (!evttree)
    {
        gLog << "Tree 'Events' not found in file... exit!" << endl;
        return -1;
    }

    //
    //  check the branches in the Tree 
    //
    gLog << " Check all the Branches in the Tree." << endl;
    gLog << endl;

    MRawEvtHeader  *evtheader = NULL;
    MTime          *evttime   = NULL;
    MRawEvtData    *evtdata   = NULL;
    MRawCrateArray *evtcrate  = NULL;
    MMcEvt         *evtmc     = NULL;
    MMcTrig        *trigmc    = NULL;

    EnableBranch(evttree, "MRawEvtHeader",  &evtheader);
    EnableBranch(evttree, "MTime",          &evttime);
    EnableBranch(evttree, "MRawEvtData",    &evtdata);
    EnableBranch(evttree, "MRawCrateArray", &evtcrate);
    EnableBranch(evttree, "MMcEvt",         &evtmc);
    EnableBranch(evttree, "MMcTrig",        &trigmc);

    //
    // loop over all entries 
    //
    Int_t nent = (Int_t)evttree->GetEntries();

    gLog << endl;
    gLog << " Entries in Tree Data: " << dec << nent << endl;
    gLog << endl;

    for (Int_t i = 0; i<nent; i++)
    {
        gLog << "Entry: " << i << endl;

        //
        // readin event with the selected branches
        //
        evttree->GetEvent(i);

        if (evtmc)
            evtmc->Print();
        if (trigmc)
            trigmc->Print();
        if (evtheader)
            evtheader->Print();
        if (evttime)
            evttime->Print();
        if (evtcrate)
            evtcrate->Print();
        if (evtdata)
            evtdata->Print();
    } 
    
    //   end of small readin program 

    return 0;
}


