/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz 04/2003 <mailto:tbretz@astro.uni-wuerzburg.de>
!
!   Copyright: MAGIC Software Development, 2000-2003
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//
//  MHBlindPixels
//
////////////////////////////////////////////////////////////////////////////
#include "MHBlindPixels.h" 

#include <TCanvas.h>

#include "MBlindPixels.h"

ClassImp(MHBlindPixels);

// -------------------------------------------------------------------------
//
//  Default Constructor.
//
MHBlindPixels::MHBlindPixels(const char *name, const char *title)
    : fHist(fName, fTitle, 577, -.5, 577-.5)
{
    fName  = name  ? name  : "MHBlindPixels";
    fTitle = title ? title : "Histogram for Blind Pixels";

    //  - we initialize the histogram
    //  - we have to give diferent names for the diferent histograms because
    //    root don't allow us to have diferent histograms with the same name

    fHist.SetName(fName);
    fHist.SetTitle(fTitle);

    fHist.SetDirectory(NULL);

    fHist.SetXTitle("Id");
    fHist.SetYTitle("Counts");
}

// ------------------------------------------------------------------------
// 
// Drawing function. It creates its own canvas.
//
void MHBlindPixels::Draw(Option_t *option)
{
    TVirtualPad *pad = gPad ? gPad : MakeDefCanvas(this);
    pad->SetBorderMode(0);

    fHist.Draw(option);

    pad->Modified();
    pad->Update();
}

Bool_t MHBlindPixels::Fill(const MParContainer *par, const Stat_t w)
{
    if (!par)
        return kFALSE;

    const MBlindPixels &bp = *(MBlindPixels*)par;

    // FIXME: Slow.
    for (int i=0; i<577; i++)
        if (bp.IsBlind(i))
            fHist.Fill(i, w);

    return kTRUE;
}
